/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.impl;

import com.dimajix.flowman.maven.plugin.impl.AbstractPackage;
import com.dimajix.flowman.maven.plugin.model.BuildSettings;
import com.dimajix.flowman.maven.plugin.model.FlowmanSettings;
import com.dimajix.flowman.maven.plugin.tasks.BuildJar;
import com.dimajix.flowman.maven.plugin.tasks.ProcessResources;
import com.dimajix.flowman.maven.plugin.tasks.RunArtifacts;
import com.dimajix.flowman.maven.plugin.tasks.ShadeJar;
import com.dimajix.flowman.maven.plugin.util.Jackson;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class JarPackage
extends AbstractPackage {
    @JsonProperty(value="includeProjects", required=false)
    private boolean includeProjects = true;

    @Override
    public String getType() {
        return "jar";
    }

    @Override
    public void build() throws MojoFailureException, MojoExecutionException {
        FlowmanSettings flowmanSettings = this.getEffectiveFlowmanSettings();
        MavenProject mavenProject = this.mojo.getCurrentMavenProject();
        File outputDirectory = new File(this.getOutputDirectory(), "META-INF/flowman");
        ProcessResources resources = new ProcessResources(this.mojo, mavenProject);
        resources.processResources(this.mojo.getDescriptor().getProjects(), outputDirectory);
        resources.processResources(this.mojo.getDescriptor().getResources(), outputDirectory);
        resources.processResources(new File("conf"), outputDirectory);
        File ns = new File(outputDirectory, "conf/default-namespace.yml");
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)Jackson.newYAMLFactory());
            ObjectNode objectTree = mapper.getNodeFactory().objectNode();
            if (ns.exists() && ns.isFile()) {
                try (FileInputStream reader = new FileInputStream(ns);){
                    JsonNode tree = mapper.reader().readTree((InputStream)reader);
                    if (tree.isObject()) {
                        objectTree = (ObjectNode)tree;
                    }
                }
                if (objectTree.findValue("plugins") != null) {
                    objectTree.without("plugins");
                }
            } else {
                ns.getParentFile().mkdirs();
            }
            List<String> configValues = flowmanSettings.getConfig();
            Jackson.mergeArray((JsonNode)objectTree, "config", configValues);
            List<String> envValues = flowmanSettings.getEnvironment();
            Jackson.mergeArray((JsonNode)objectTree, "environment", envValues);
            mapper.writer().writeValue(ns, (Object)objectTree);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Error processing '" + ns + "'", (Throwable)ex);
        }
    }

    @Override
    public void test(File project) throws MojoFailureException, MojoExecutionException {
        MavenProject mavenProject = this.mojo.getCurrentMavenProject();
        File outputDirectory = new File(this.getOutputDirectory(), "META-INF/flowman");
        File confDirectory = new File(outputDirectory, "conf");
        List<File> projectDirectories = project != null ? Collections.singletonList(project) : this.mojo.getDescriptor().getProjects();
        RunArtifacts run = new RunArtifacts(this.mojo, mavenProject, null, confDirectory, this.getEffectiveExecutionSettings());
        for (File flow : projectDirectories) {
            File projectDirectory = new File(outputDirectory, flow.getPath());
            run.runTests(projectDirectory);
        }
    }

    @Override
    public void pack() throws MojoFailureException, MojoExecutionException {
        MavenProject mavenProject = this.mojo.getCurrentMavenProject();
        File buildDirectory = this.getBuildDirectory();
        File outputDirectory = this.getOutputDirectory();
        List<File> exclusions = this.includeProjects ? Collections.emptyList() : Stream.concat(this.mojo.getDescriptor().getProjects().stream(), this.mojo.getDescriptor().getResources().stream()).map(src -> new File("META-INF/flowman", src.toString())).collect(Collectors.toList());
        BuildJar jar = new BuildJar(this.mojo, mavenProject);
        jar.buildJar(outputDirectory, buildDirectory, exclusions);
        ShadeJar shade = new ShadeJar(this.mojo, mavenProject, this.getEffectiveBuildSettings());
        shade.shadeJar("com.dimajix.flowman.tools.exec.Driver", this.getName());
        Artifact artifact = mavenProject.getArtifact();
        this.mojo.attachArtifact(artifact.getFile(), artifact.getType(), this.getName());
        Log log = this.mojo.getLog();
        log.info((CharSequence)"");
        log.info((CharSequence)(" > Run 'flowexec' via 'spark-submit " + artifact.getFile().getName() + " -f <project-directory> <flowman-command>'"));
        log.info((CharSequence)(" > Run 'flowshell' via 'spark-submit --class com.dimajix.flowman.tools.shell.Shell " + artifact.getFile().getName() + " -f <project-directory>'"));
    }

    @Override
    public void shell(File project) throws MojoExecutionException, MojoFailureException {
        MavenProject mavenProject = this.mojo.getCurrentMavenProject();
        File outputDirectory = new File(this.getOutputDirectory(), "META-INF/flowman");
        File projectDirectory = new File(outputDirectory, project.getPath());
        File confDirectory = new File(outputDirectory, "conf");
        RunArtifacts run = new RunArtifacts(this.mojo, mavenProject, null, confDirectory, this.getEffectiveExecutionSettings());
        run.runShell(projectDirectory);
    }

    @Override
    public void push() throws MojoFailureException, MojoExecutionException {
    }

    @Override
    public List<Dependency> getDependencies() throws MojoFailureException {
        FlowmanSettings flowmanSettings = this.getEffectiveFlowmanSettings();
        BuildSettings buildSettings = this.getEffectiveBuildSettings();
        Artifact flowmanTools = flowmanSettings.resolveTools();
        Artifact flowmanSpark = flowmanSettings.resolveSparkDependencies();
        List<Artifact> flowmanPlugins = flowmanSettings.resolvePluginJars();
        List<Artifact> dependencies = buildSettings.resolveDependencies();
        LinkedList<Artifact> allDeps = new LinkedList<Artifact>();
        allDeps.add(flowmanTools);
        allDeps.add(flowmanSpark);
        allDeps.addAll(dependencies);
        allDeps.addAll(flowmanPlugins);
        return this.toDependencies(allDeps);
    }
}

