/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.interpolation;

import com.dimajix.flowman.maven.plugin.interpolation.InterpolationConstants;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.fixed.PropertiesBasedValueSource;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class StringInterpolator {
    public static FixedStringSearchInterpolator createInterpolator(MavenSession session, MavenProject project) {
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{StringInterpolator.createRepositoryInterpolator(session), StringInterpolator.createCommandLinePropertiesInterpolator(session), StringInterpolator.createEnvInterpolator(), StringInterpolator.createProjectInterpolator(project)});
    }

    private static FixedStringSearchInterpolator createProjectInterpolator(MavenProject project) {
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{new PrefixedPropertiesValueSource(InterpolationConstants.PROJECT_PROPERTIES_PREFIXES, project.getProperties(), true), new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, (Object)project, true)});
    }

    private static FixedStringSearchInterpolator createRepositoryInterpolator(MavenSession session) {
        Properties settingsProperties = new Properties();
        if (session.getSettings() != null) {
            settingsProperties.setProperty("localRepository", session.getSettings().getLocalRepository());
        }
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{new PropertiesBasedValueSource(settingsProperties)});
    }

    private static FixedStringSearchInterpolator createCommandLinePropertiesInterpolator(MavenSession session) {
        Properties commandLineProperties = System.getProperties();
        if (session != null) {
            commandLineProperties = new Properties();
            commandLineProperties.putAll((Map<?, ?>)session.getSystemProperties());
            commandLineProperties.putAll((Map<?, ?>)session.getUserProperties());
        }
        PropertiesBasedValueSource cliProps = new PropertiesBasedValueSource(commandLineProperties);
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{cliProps});
    }

    private static FixedStringSearchInterpolator createEnvInterpolator() {
        try {
            PrefixedPropertiesValueSource envProps = new PrefixedPropertiesValueSource(Collections.singletonList("env."), CommandLineUtils.getSystemEnvVars((boolean)false), true);
            return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{envProps});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

