/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.model;

import com.dimajix.flowman.maven.plugin.util.Artifacts;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;

public class BuildSettings {
    @JsonProperty(value="properties", required=false)
    private List<String> properties = Collections.emptyList();
    @JsonProperty(value="dependencies", required=false)
    private List<String> dependencies = Collections.emptyList();
    @JsonProperty(value="exclusions", required=false)
    private List<String> exclusions = Collections.emptyList();

    public Map<String, String> getPropertiesMap() {
        return this.properties.stream().map(p -> StringUtils.split((String)p, (String)"=", (int)2)).filter(k -> ((String[])k).length == 2).collect(Collectors.toMap(k -> k[0], v -> v[1]));
    }

    public List<Artifact> resolveDependencies() {
        return this.dependencies.stream().map(Artifacts::parseCoordinates).collect(Collectors.toList());
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    @JsonProperty(value="properties", required=false)
    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="dependencies", required=false)
    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    @JsonProperty(value="exclusions", required=false)
    public void setExclusions(List<String> exclusions) {
        this.exclusions = exclusions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildSettings)) {
            return false;
        }
        BuildSettings other = (BuildSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$properties = this.getProperties();
        List<String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<String> this$dependencies = this.getDependencies();
        List<String> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<String> this$exclusions = this.getExclusions();
        List<String> other$exclusions = other.getExclusions();
        return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<String> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        return result;
    }

    public String toString() {
        return "BuildSettings(properties=" + this.getProperties() + ", dependencies=" + this.getDependencies() + ", exclusions=" + this.getExclusions() + ")";
    }
}

