/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.model;

import com.dimajix.flowman.maven.plugin.util.Artifacts;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;

public class FlowmanSettings {
    @JsonProperty(value="version", required=true)
    private String version;
    @JsonProperty(value="distribution", required=false)
    private String distribution;
    @JsonProperty(value="plugins", required=false)
    private List<String> plugins = Collections.emptyList();
    @JsonProperty(value="environment", required=false)
    private List<String> environment = Collections.emptyList();
    @JsonProperty(value="config", required=false)
    private List<String> config = Collections.emptyList();

    public Artifact resolveDist() {
        return new DefaultArtifact("com.dimajix.flowman", "flowman-dist", this.version, "provided", "tar.gz", "bin", (ArtifactHandler)new DefaultArtifactHandler());
    }

    public Artifact resolveParent() {
        return new DefaultArtifact("com.dimajix.flowman", "flowman-parent", this.version, "import", "pom", null, (ArtifactHandler)new DefaultArtifactHandler());
    }

    public Artifact resolveSparkDependencies() {
        return new DefaultArtifact("com.dimajix.flowman", "flowman-spark-dependencies", this.version, "provided", "pom", null, (ArtifactHandler)new DefaultArtifactHandler());
    }

    public Artifact resolveTools() {
        return new DefaultArtifact("com.dimajix.flowman", "flowman-tools", this.version, "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler());
    }

    public List<Artifact> resolvePluginJars() {
        return this.resolvePlugins("jar", null);
    }

    public List<Artifact> resolvePluginDists() {
        return this.resolvePlugins("tar.gz", "bin");
    }

    private List<Artifact> resolvePlugins(String type, String classifier) {
        Pattern builtinPluginRegex = Pattern.compile("flowman-([a-z0-9]+)");
        return this.plugins.stream().map(d -> {
            Matcher matcher = builtinPluginRegex.matcher((CharSequence)d);
            if (matcher.matches()) {
                String pluginSuffix = matcher.group(1);
                return "com.dimajix.flowman:flowman-plugin-" + pluginSuffix;
            }
            return d;
        }).map(d -> Artifacts.parseCoordinates(d, type, classifier, this.version)).collect(Collectors.toList());
    }

    public String getVersion() {
        return this.version;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public List<String> getEnvironment() {
        return this.environment;
    }

    public List<String> getConfig() {
        return this.config;
    }

    @JsonProperty(value="version", required=true)
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="distribution", required=false)
    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    @JsonProperty(value="plugins", required=false)
    public void setPlugins(List<String> plugins) {
        this.plugins = plugins;
    }

    @JsonProperty(value="environment", required=false)
    public void setEnvironment(List<String> environment) {
        this.environment = environment;
    }

    @JsonProperty(value="config", required=false)
    public void setConfig(List<String> config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowmanSettings)) {
            return false;
        }
        FlowmanSettings other = (FlowmanSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        List<String> this$plugins = this.getPlugins();
        List<String> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<String> this$environment = this.getEnvironment();
        List<String> other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        List<String> this$config = this.getConfig();
        List<String> other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowmanSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        List<String> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<String> $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        List<String> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    public String toString() {
        return "FlowmanSettings(version=" + this.getVersion() + ", distribution=" + this.getDistribution() + ", plugins=" + this.getPlugins() + ", environment=" + this.getEnvironment() + ", config=" + this.getConfig() + ")";
    }
}

