/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;

public class ObjectMapper {
    private ObjectMapper() {
    }

    static com.fasterxml.jackson.databind.ObjectMapper getMapper() {
        com.fasterxml.jackson.databind.ObjectMapper mapper = new com.fasterxml.jackson.databind.ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    public static <T> T read(File file, Class<T> valueType, FixedStringSearchInterpolator intp) throws IOException {
        com.fasterxml.jackson.databind.ObjectMapper mapper = ObjectMapper.getMapper();
        JsonNode tree = mapper.readTree(file);
        return ObjectMapper.convertTree(tree, valueType, intp);
    }

    public static <T> T read(URL url, Class<T> valueType, FixedStringSearchInterpolator intp) throws IOException {
        com.fasterxml.jackson.databind.ObjectMapper mapper = ObjectMapper.getMapper();
        JsonNode tree = mapper.readTree(url);
        return ObjectMapper.convertTree(tree, valueType, intp);
    }

    public static <T> T read(String spec, Class<T> valueType, FixedStringSearchInterpolator intp) throws IOException {
        com.fasterxml.jackson.databind.ObjectMapper mapper = ObjectMapper.getMapper();
        JsonNode tree = mapper.readTree(spec);
        return ObjectMapper.convertTree(tree, valueType, intp);
    }

    private static <T> T convertTree(JsonNode tree, Class<T> valueType, FixedStringSearchInterpolator intp) throws JsonProcessingException {
        JsonNode newTree = ObjectMapper.applyThings(tree, intp);
        com.fasterxml.jackson.databind.ObjectMapper mapper = ObjectMapper.getMapper();
        return (T)mapper.treeToValue((TreeNode)newTree, valueType);
    }

    private static JsonNode applyThings(JsonNode node, FixedStringSearchInterpolator intp) {
        if (node.isObject()) {
            ObjectNode obj = (ObjectNode)node;
            HashMap<String, JsonNode> newChildren = new HashMap<String, JsonNode>();
            Iterator it = obj.fields();
            while (it.hasNext()) {
                Map.Entry namedChild = (Map.Entry)it.next();
                JsonNode newChild = ObjectMapper.applyThings((JsonNode)namedChild.getValue(), intp);
                newChildren.put((String)namedChild.getKey(), newChild);
            }
            obj.setAll(newChildren);
            return obj;
        }
        if (node.isTextual()) {
            String text = node.asText();
            String newText = intp.interpolate(text);
            return TextNode.valueOf((String)newText);
        }
        if (node.isArray()) {
            ArrayNode ary = (ArrayNode)node;
            LinkedList<JsonNode> newElements = new LinkedList<JsonNode>();
            Iterator it = ary.elements();
            while (it.hasNext()) {
                JsonNode elem = (JsonNode)it.next();
                JsonNode newElement = ObjectMapper.applyThings(elem, intp);
                newElements.add(newElement);
            }
            ary.removeAll();
            ary.addAll(newElements);
            return ary;
        }
        return node;
    }
}

