/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.mojos;

import com.dimajix.flowman.maven.plugin.interpolation.StringInterpolator;
import com.dimajix.flowman.maven.plugin.model.BuildSettings;
import com.dimajix.flowman.maven.plugin.model.Deployment;
import com.dimajix.flowman.maven.plugin.model.Descriptor;
import com.dimajix.flowman.maven.plugin.model.FlowmanSettings;
import com.dimajix.flowman.maven.plugin.model.ObjectMapper;
import com.dimajix.flowman.maven.plugin.model.Package;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public abstract class FlowmanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    protected BuildPluginManager pluginManager;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Inject
    protected ProjectDependenciesResolver dependenciesResolver;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Inject
    protected ArtifactDescriptorReader artifactDescriptorReader;
    @Inject
    protected MavenProjectHelper mavenProjectHelper;
    @Parameter(defaultValue="${project.build.directory}", property="flowman.buildDirectory")
    protected File buildDirectory;
    @Parameter(defaultValue="${project.directory}/deployment.yml", property="flowman.deploymentDescriptor")
    protected File deploymentDescriptor;
    private Descriptor cachedDescriptor = null;

    public Descriptor getDescriptor() throws MojoFailureException {
        if (this.cachedDescriptor == null) {
            try {
                FixedStringSearchInterpolator interpolator = StringInterpolator.createInterpolator(this.mavenSession, this.mavenProject);
                this.cachedDescriptor = ObjectMapper.read(this.deploymentDescriptor, Descriptor.class, interpolator);
                for (Package pkg : this.cachedDescriptor.getPackages()) {
                    pkg.init(this);
                }
                for (Deployment deployment : this.cachedDescriptor.getDeployments()) {
                    deployment.init(this);
                }
            }
            catch (IOException ex) {
                throw new MojoFailureException("Error reading " + this.deploymentDescriptor + " descriptor", (Throwable)ex);
            }
        }
        return this.cachedDescriptor;
    }

    public MavenProject getCurrentMavenProject() {
        return this.mavenSession.getCurrentProject();
    }

    public List<Package> getPackages() throws MojoFailureException {
        return this.getDescriptor().getPackages();
    }

    public Package getPackage(String name) throws MojoExecutionException, MojoFailureException {
        List<Package> pkgs = this.getDescriptor().getPackages();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return pkgs.iterator().next();
        }
        Optional<Package> result = pkgs.stream().filter(d -> d.getName().equals(name)).findFirst();
        if (!result.isPresent()) {
            throw new MojoExecutionException("Flowman package '" + name + "' found. Please check your 'deployment.yml'.");
        }
        return result.get();
    }

    public List<Deployment> getDeployments() throws MojoFailureException {
        return this.getDescriptor().getDeployments();
    }

    public Deployment getDeployment(String name) throws MojoExecutionException, MojoFailureException {
        List<Deployment> deployments = this.getDescriptor().getDeployments();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return deployments.iterator().next();
        }
        Optional<Deployment> result = deployments.stream().filter(d -> d.getName().equals(name)).findFirst();
        if (!result.isPresent()) {
            throw new MojoExecutionException("Flowman deployment '" + name + "' found. Please check your 'deployment.yml'.");
        }
        return result.get();
    }

    public File getFlowmanProject(String name) throws MojoExecutionException, MojoFailureException {
        List<File> projects = this.getDescriptor().getProjects();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return projects.iterator().next();
        }
        Optional<File> result = projects.stream().filter(f -> f.getName().equalsIgnoreCase(name)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        throw new MojoExecutionException("Flowman project '" + name + "' not found. Please check your 'deployment.yml'.");
    }

    protected MavenProject createMavenProject(Package pkg) throws MojoFailureException, MojoExecutionException {
        MavenProject mojoProject = this.getMavenProject();
        Artifact artifact = pkg.getArtifact();
        Build mojoBuild = mojoProject.getBuild();
        Build build = mojoBuild.clone();
        build.setDirectory(new File(this.buildDirectory, pkg.getName()).toString());
        build.setOutputDirectory(new File(new File(this.buildDirectory, pkg.getName()), "resources").toString());
        Model model = mojoProject.getModel().clone();
        MavenProject mavenProject = new MavenProject(model);
        mavenProject.setOriginalModel(mojoProject.getModel());
        mavenProject.setBuild(build);
        mavenProject.setFile(mojoProject.getFile());
        mavenProject.setArtifact(artifact);
        mavenProject.setRemoteArtifactRepositories(mojoProject.getRemoteArtifactRepositories());
        mavenProject.setPluginArtifactRepositories(mojoProject.getPluginArtifactRepositories());
        mavenProject.setDistributionManagement(mojoProject.getDistributionManagement());
        BuildSettings buildSettings = pkg.getEffectiveBuildSettings();
        for (String prop : buildSettings.getProperties()) {
            String[] parts = prop.split("=", 2);
            if (parts.length != 2) continue;
            model.addProperty(parts[0], parts[1]);
        }
        FlowmanSettings flowmanSettings = pkg.getEffectiveFlowmanSettings();
        Artifact parent0 = flowmanSettings.resolveParent();
        this.importDependencyManagement(mavenProject, parent0);
        List<Dependency> dependencies = pkg.getDependencies();
        mavenProject.setDependencies(dependencies);
        return mavenProject;
    }

    public void attachArtifact(File artifactFile, String artifactClassifier) {
        this.mavenProjectHelper.attachArtifact(this.mavenProject, artifactFile, artifactClassifier);
    }

    public void attachArtifact(File artifactFile, String artifactType, String artifactClassifier) {
        this.mavenProjectHelper.attachArtifact(this.mavenProject, artifactType, artifactClassifier, artifactFile);
    }

    private void importDependencyManagement(MavenProject mavenProject, Artifact pom) throws MojoFailureException {
        ArtifactDescriptorResult result;
        this.getLog().debug((CharSequence)("Importing " + pom.getGroupId() + ":" + pom.getArtifactId() + ":" + pom.getType() + ":" + pom.getVersion()));
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest();
        DefaultArtifact parent = new DefaultArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getType(), pom.getVersion());
        request.setArtifact((org.eclipse.aether.artifact.Artifact)parent);
        DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession(this.getMavenSession().getRepositorySession());
        repositorySystemSession.setUserProperties((Map)mavenProject.getProperties());
        try {
            result = this.getArtifactDescriptorReader().readArtifactDescriptor((RepositorySystemSession)repositorySystemSession, request);
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoFailureException("Error reading artifact descriptor '" + request + "'", (Throwable)e);
        }
        DependencyManagement depMgmt = new DependencyManagement();
        result.getManagedDependencies().forEach(dep0 -> {
            Dependency dep = new Dependency();
            org.eclipse.aether.artifact.Artifact artifact = dep0.getArtifact();
            this.getLog().debug((CharSequence)("Adding dependency management: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()));
            dep.setGroupId(artifact.getGroupId());
            dep.setArtifactId(artifact.getArtifactId());
            dep.setClassifier(StringUtils.isNotEmpty((CharSequence)artifact.getClassifier()) ? artifact.getClassifier() : null);
            dep.setVersion(artifact.getVersion());
            dep.setType(artifact.getExtension());
            dep.setScope(dep0.getScope());
            if (dep0.getExclusions() != null) {
                List exclusions = dep0.getExclusions().stream().map(ex0 -> {
                    Exclusion ex = new Exclusion();
                    ex.setGroupId(ex0.getGroupId());
                    ex.setArtifactId(ex0.getArtifactId());
                    return ex;
                }).collect(Collectors.toList());
                dep.setExclusions(exclusions);
            }
            depMgmt.addDependency(dep);
        });
        this.importManagement(mavenProject.getModel(), depMgmt, true);
    }

    private void importManagement(Model target, DependencyManagement source, boolean overrideTarget) {
        LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
        DependencyManagement depMgmt = target.getDependencyManagement();
        if (depMgmt != null) {
            for (Dependency dependency : depMgmt.getDependencies()) {
                dependencies.put(dependency.getManagementKey(), dependency);
            }
        } else {
            depMgmt = new DependencyManagement();
            target.setDependencyManagement(depMgmt);
        }
        for (Dependency dependency : source.getDependencies()) {
            String key = dependency.getManagementKey();
            if (!overrideTarget && dependencies.containsKey(key)) continue;
            dependencies.put(key, dependency);
        }
        depMgmt.setDependencies(new ArrayList(dependencies.values()));
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public BuildPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public ProjectDependenciesResolver getDependenciesResolver() {
        return this.dependenciesResolver;
    }

    public ArtifactHandlerManager getArtifactHandlerManager() {
        return this.artifactHandlerManager;
    }

    public ArtifactDescriptorReader getArtifactDescriptorReader() {
        return this.artifactDescriptorReader;
    }

    public MavenProjectHelper getMavenProjectHelper() {
        return this.mavenProjectHelper;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }
}

