/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.mojos;

import com.dimajix.flowman.maven.plugin.model.Package;
import com.dimajix.flowman.maven.plugin.mojos.FlowmanMojo;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="package", threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class PackageMojo
extends FlowmanMojo {
    @Parameter(property="flowman.package")
    protected String pkg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Package> packages = StringUtils.isEmpty((CharSequence)this.pkg) ? this.getPackages() : Collections.singletonList(this.getPackage(this.pkg));
        for (Package pkg : packages) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("-- Packaging package '" + pkg.getName() + "'"));
            MavenProject project = this.createMavenProject(pkg);
            MavenProject previousProject = this.mavenSession.getCurrentProject();
            try {
                this.mavenSession.setCurrentProject(project);
                pkg.pack();
            }
            finally {
                this.mavenSession.setCurrentProject(previousProject);
            }
        }
        this.mavenProject.getArtifact().setFile(this.mavenProject.getFile());
    }
}

