/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.mojos;

import com.dimajix.flowman.maven.plugin.model.Package;
import com.dimajix.flowman.maven.plugin.mojos.FlowmanMojo;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="test", threadSafe=true, defaultPhase=LifecyclePhase.TEST)
public class TestMojo
extends FlowmanMojo {
    @Parameter(property="flowman.package")
    protected String pkg;
    @Parameter(property="flowman.project")
    protected String project;
    @Parameter(property="skipTests")
    protected Boolean skipTests = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipTests.booleanValue()) {
            List<Package> packages = StringUtils.isEmpty((CharSequence)this.pkg) ? this.getPackages() : Collections.singletonList(this.getPackage(this.pkg));
            for (Package pkg : packages) {
                this.getLog().info((CharSequence)"");
                if (this.skipTests.booleanValue() || pkg.isSkipTests()) {
                    this.getLog().info((CharSequence)("-- Skipping test package '" + pkg.getName() + "'"));
                    continue;
                }
                this.getLog().info((CharSequence)("-- Testing package '" + pkg.getName() + "'"));
                MavenProject mavenProject = this.createMavenProject(pkg);
                MavenProject previousProject = this.mavenSession.getCurrentProject();
                try {
                    this.mavenSession.setCurrentProject(mavenProject);
                    File flow = this.project != null ? this.getFlowmanProject(this.project) : null;
                    pkg.test(flow);
                }
                finally {
                    this.mavenSession.setCurrentProject(previousProject);
                }
            }
        }
    }
}

