/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.tasks;

import com.dimajix.flowman.maven.fs.FileSystem;
import com.dimajix.flowman.maven.plugin.mojos.FlowmanMojo;
import com.dimajix.flowman.maven.plugin.tasks.Task;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;

public class ResolveArtifact
extends Task {
    private final Log log;
    private final ArtifactResolver artifactResolver;
    private final ArtifactHandlerManager artifactHandlerManager;

    public ResolveArtifact(FlowmanMojo mojo, MavenProject mavenProject) throws MojoFailureException {
        super(mojo, mavenProject);
        this.log = mojo.getLog();
        this.artifactResolver = mojo.getArtifactResolver();
        this.artifactHandlerManager = mojo.getArtifactHandlerManager();
    }

    public Artifact resolve(Artifact artifact) throws MojoExecutionException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(artifact.getType());
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId(artifact.getGroupId());
        artifactCoordinate.setArtifactId(artifact.getArtifactId());
        artifactCoordinate.setVersion(artifact.getVersion());
        artifactCoordinate.setClassifier(artifact.getClassifier());
        artifactCoordinate.setExtension(artifactHandler.getExtension());
        ProjectBuildingRequest buildingRequest = this.mavenSession.getProjectBuildingRequest();
        try {
            if (artifact.getFile() == null || !artifact.getFile().exists()) {
                ArtifactResult result = this.artifactResolver.resolveArtifact(buildingRequest, (ArtifactCoordinate)artifactCoordinate);
                artifact.setFile(result.getArtifact().getFile());
                return result.getArtifact();
            }
            return artifact;
        }
        catch (ArtifactResolverException ex) {
            throw new MojoExecutionException("Error resolving artifact '" + artifact.getId() + "'", (Exception)((Object)ex));
        }
    }

    public void copy(Artifact artifact, URI targetLocation) throws MojoExecutionException {
        Artifact artifact2 = this.resolve(artifact);
        try {
            File source = artifact2.getFile();
            URI target = new URI(targetLocation + "/").resolve(source.getName());
            FileSystem fs = FileSystem.getFileSystem(target.getScheme());
            this.log.info((CharSequence)("Copying " + source + " to " + target));
            fs.put(target, source);
        }
        catch (URISyntaxException ex) {
            throw new MojoExecutionException("Error copying artifact '" + artifact.getId() + "' to '" + targetLocation + "'", (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error copying artifact '" + artifact.getId() + "' to '" + targetLocation + "'", (Exception)ex);
        }
    }
}

