/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.tasks;

import com.dimajix.flowman.maven.plugin.model.ExecutionSettings;
import com.dimajix.flowman.maven.plugin.mojos.FlowmanMojo;
import com.dimajix.flowman.maven.plugin.tasks.Task;
import com.dimajix.flowman.maven.plugin.util.Collections;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class RunArtifacts
extends Task {
    private final File homeDirectory;
    private final File confDirectory;
    private final ExecutionSettings executionSettings;
    private static final String[] extraJavaArgs = new String[]{"-XX:+IgnoreUnrecognizedVMOptions", "--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.lang.invoke=ALL-UNNAMED", "--add-opens=java.base/java.lang.reflect=ALL-UNNAMED", "--add-opens=java.base/java.io=ALL-UNNAMED", "--add-opens=java.base/java.net=ALL-UNNAMED", "--add-opens=java.base/java.nio=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED", "--add-opens=java.base/java.util.concurrent=ALL-UNNAMED", "--add-opens=java.base/java.util.concurrent.atomic=ALL-UNNAMED", "--add-opens=java.base/sun.nio.ch=ALL-UNNAMED", "--add-opens=java.base/sun.nio.cs=ALL-UNNAMED", "--add-opens=java.base/sun.security.action=ALL-UNNAMED", "--add-opens=java.base/sun.util.calendar=ALL-UNNAMED", "-Djdk.reflect.useDirectMethodHandle=false"};

    public RunArtifacts(FlowmanMojo mojo, MavenProject mavenProject, ExecutionSettings executionSettings) throws MojoFailureException {
        super(mojo, mavenProject);
        this.confDirectory = null;
        this.homeDirectory = null;
        this.executionSettings = executionSettings;
    }

    public RunArtifacts(FlowmanMojo mojo, MavenProject mavenProject, File homeDirectory, File confDirectory, ExecutionSettings executionSettings) throws MojoFailureException {
        super(mojo, mavenProject);
        this.homeDirectory = homeDirectory;
        this.confDirectory = confDirectory;
        this.executionSettings = executionSettings;
    }

    public void runTests(File projectDirectory) throws MojoExecutionException, MojoFailureException {
        this.run("com.dimajix.flowman.tools.exec.Driver", projectDirectory, "test", "run");
    }

    public void runShell(File projectDirectory) throws MojoExecutionException, MojoFailureException {
        this.run("com.dimajix.flowman.tools.shell.Shell", projectDirectory, new String[0]);
    }

    public void run(String mainClass, File projectDirectory, String ... args) throws MojoExecutionException, MojoFailureException {
        DependencyResolutionResult depres = this.resolveDependencies();
        StringBuffer classPath = new StringBuffer();
        depres.getResolvedDependencies().stream().forEach(dep -> {
            if (classPath.length() > 0) {
                classPath.append(File.pathSeparator);
            }
            classPath.append(dep.getArtifact().getFile());
        });
        LinkedList<String> allArgs = new LinkedList<String>();
        List<String> args0 = Arrays.asList("-classpath", classPath.toString(), mainClass, "-f", projectDirectory.toString());
        allArgs.addAll(Arrays.stream(extraJavaArgs).collect(Collectors.toList()));
        allArgs.addAll(this.executionSettings.getJavaOptions());
        allArgs.addAll(args0);
        allArgs.addAll(this.executionSettings.getFlowmanOptions());
        this.executionSettings.getProfiles().forEach(p -> {
            allArgs.add("-P");
            allArgs.add((String)p);
        });
        this.executionSettings.getEnvironment().forEach(e -> {
            allArgs.add("-D");
            allArgs.add((String)e);
        });
        this.executionSettings.getConfig().forEach(c -> {
            allArgs.add("--conf");
            allArgs.add((String)c);
        });
        allArgs.addAll(Arrays.asList(args));
        HashMap<String, String> systemEnvironment = new HashMap<String, String>();
        systemEnvironment.put("FLOWMAN_HOME", this.homeDirectory != null ? this.homeDirectory.toString() : "");
        systemEnvironment.put("FLOWMAN_CONF_DIR", this.confDirectory != null ? this.confDirectory.toString() : "");
        systemEnvironment.putAll(Collections.splitSettings(this.executionSettings.getSystemEnvironment()));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.codehaus.mojo"), (String)MojoExecutor.artifactId((String)"exec-maven-plugin"), (String)MojoExecutor.version((String)"3.1.0")), (String)MojoExecutor.goal((String)"exec"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"addOutputToClasspath"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"classpathScope"), (String)"compile"), MojoExecutor.element((String)MojoExecutor.name((String)"inheritIo"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"environmentVariables"), (MojoExecutor.Element[])((MojoExecutor.Element[])systemEnvironment.entrySet().stream().map(arg -> MojoExecutor.element((String)MojoExecutor.name((String)((String)arg.getKey())), (String)((String)arg.getValue()))).toArray(MojoExecutor.Element[]::new))), MojoExecutor.element((String)MojoExecutor.name((String)"executable"), (String)"java"), MojoExecutor.element((String)MojoExecutor.name((String)"arguments"), (MojoExecutor.Element[])((MojoExecutor.Element[])allArgs.stream().map(arg -> MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)arg)).toArray(MojoExecutor.Element[]::new)))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }
}

