/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.tasks;

import com.dimajix.flowman.maven.plugin.model.BuildSettings;
import com.dimajix.flowman.maven.plugin.mojos.FlowmanMojo;
import com.dimajix.flowman.maven.plugin.tasks.Task;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class ShadeJar
extends Task {
    private final BuildSettings buildSettings;

    public ShadeJar(FlowmanMojo mojo, MavenProject mavenProject, BuildSettings buildSettings) throws MojoFailureException {
        super(mojo, mavenProject);
        this.buildSettings = buildSettings;
        mavenProject.getModel().setPackaging("jar");
    }

    public void shadeJar(String mainClass, String classifier) throws MojoExecutionException, MojoFailureException {
        this.resolveDependencies();
        Set newDeps = this.mavenProject.getArtifacts().stream().filter(a -> !a.getScope().equals("provided")).collect(Collectors.toSet());
        this.mavenProject.setArtifacts(newDeps);
        LinkedList<String> exclusions = new LinkedList<String>(this.buildSettings.getExclusions());
        exclusions.add("com.dimajix.flowman:flowman-spark-dependencies:*");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-shade-plugin"), (String)MojoExecutor.version((String)"3.4.0")), (String)MojoExecutor.goal((String)"shade"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"shadedClassifierName"), (String)classifier), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.buildDirectory.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"createDependencyReducedPom"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"keepDependenciesWithProvidedScope"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"transformers"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"transformer"), (MojoExecutor.Attribute)MojoExecutor.attribute((String)"implementation", (String)"org.apache.maven.plugins.shade.resource.ApacheLicenseResourceTransformer"), (MojoExecutor.Element[])new MojoExecutor.Element[0]), MojoExecutor.element((String)MojoExecutor.name((String)"transformer"), (MojoExecutor.Attribute)MojoExecutor.attribute((String)"implementation", (String)"org.apache.maven.plugins.shade.resource.ApacheNoticeResourceTransformer"), (MojoExecutor.Element[])new MojoExecutor.Element[0]), MojoExecutor.element((String)MojoExecutor.name((String)"transformer"), (MojoExecutor.Attribute)MojoExecutor.attribute((String)"implementation", (String)"org.apache.maven.plugins.shade.resource.ServicesResourceTransformer"), (MojoExecutor.Element[])new MojoExecutor.Element[0]), MojoExecutor.element((String)MojoExecutor.name((String)"transformer"), (MojoExecutor.Attribute)MojoExecutor.attribute((String)"implementation", (String)"org.apache.maven.plugins.shade.resource.ManifestResourceTransformer"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"manifestEntries"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"Main-Class"), (String)mainClass)})})}), MojoExecutor.element((String)MojoExecutor.name((String)"artifactSet"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"*:*")}), MojoExecutor.element((String)MojoExecutor.name((String)"excludes"), (MojoExecutor.Element[])((MojoExecutor.Element[])exclusions.stream().map(ex -> MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)ex)).toArray(MojoExecutor.Element[]::new)))}), MojoExecutor.element((String)MojoExecutor.name((String)"filters"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"filter"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"artifact"), (String)"*:*"), MojoExecutor.element((String)MojoExecutor.name((String)"excludes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)"META-INF/versions/**"), MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)"META-INF/MANIFEST.MF"), MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)"META-INF/DEPENDENCIES"), MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)"META-INF/*.SF"), MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)"META-INF/*.DAS"), MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)"META-INF/*.RSA")})})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }
}

