/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.tasks;

import com.dimajix.flowman.maven.plugin.mojos.FlowmanMojo;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepositoryManager;

public abstract class Task {
    protected MavenProject mavenProject;
    protected MavenSession mavenSession;
    protected BuildPluginManager pluginManager;
    protected ProjectDependenciesResolver dependenciesResolver;
    protected File buildDirectory;

    public Task(FlowmanMojo mojo, MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        this.mavenSession = mojo.getMavenSession();
        this.pluginManager = mojo.getPluginManager();
        this.dependenciesResolver = mojo.getDependenciesResolver();
        this.buildDirectory = new File(mavenProject.getBuild().getDirectory());
    }

    public Artifact getArtifact() {
        return this.mavenProject.getArtifact();
    }

    protected DependencyResolutionResult resolveDependencies() throws MojoExecutionException {
        DependencyResolutionResult resolutionResult;
        RepositorySystemSession repositorySystemSession = this.mavenSession.getRepositorySession();
        try {
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(this.mavenProject, repositorySystemSession);
            resolutionResult = this.dependenciesResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Error resolving dependencies", (Exception)((Object)e));
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(this.mavenProject.getArtifact().getId()), null);
            LocalRepositoryManager lrm = repositorySystemSession.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        this.mavenProject.setResolvedArtifacts(artifacts);
        this.mavenProject.setArtifacts(artifacts);
        return resolutionResult;
    }
}

