/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.dimajix.flowman.maven.fs.FileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;

public class S3FileSystem
implements FileSystem {
    public String getScheme() {
        return "s3";
    }

    public void put(URI target, File source) throws IOException {
        AmazonS3 s3Client = AmazonS3ClientBuilder.defaultClient();
        String bucket = this.getBucket(target);
        String path = this.getPath(target);
        s3Client.putObject(bucket, path, source);
    }

    public void putAll(URI target, File sources) throws IOException {
        AmazonS3 s3Client = AmazonS3ClientBuilder.defaultClient();
        TransferManager tm = TransferManagerBuilder.standard().withS3Client(s3Client).build();
        String bucket = this.getBucket(target);
        String path = this.getPath(target);
        MultipleFileUpload upload = tm.uploadDirectory(bucket, path, sources, true);
        try {
            upload.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void delete(URI target, boolean recursive) throws IOException {
        AmazonS3 s3Client = AmazonS3ClientBuilder.defaultClient();
        String bucket = this.getBucket(target);
        String path = this.getPath(target);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucket).withPrefix(path);
        ObjectListing objectListing = s3Client.listObjects(listObjectsRequest);
        while (true) {
            for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                s3Client.deleteObject(bucket, objectSummary.getKey());
            }
            if (!objectListing.isTruncated()) break;
            objectListing = s3Client.listNextBatchOfObjects(objectListing);
        }
        if (s3Client.doesObjectExist(bucket, path)) {
            s3Client.deleteObject(bucket, path);
        }
    }

    private String getBucket(URI uri) {
        String host = uri.getHost();
        if (host != null) {
            return host;
        }
        Optional<String> bucket = Arrays.stream(uri.getPath().split("/")).filter(s -> !s.isEmpty()).findFirst();
        if (bucket.isPresent()) {
            return bucket.get();
        }
        throw new IllegalArgumentException("URI does not contain bucket: " + uri);
    }

    private String getPath(URI uri) {
        String path = this.getPath0(uri);
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private String getPath0(URI uri) {
        String host = uri.getHost();
        if (host != null) {
            return uri.getPath();
        }
        String[] parts = (String[])Arrays.stream(uri.getPath().split("/")).filter(s -> !s.isEmpty()).toArray(String[]::new);
        Optional<String> path = Arrays.stream(Arrays.copyOfRange(parts, 1, parts.length)).reduce((l, r) -> l + "/" + r);
        if (path.isPresent()) {
            return path.get();
        }
        throw new IllegalArgumentException("URI does not contain path: " + uri);
    }
}

