/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.dimajix.flowman.maven.fs.FileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class AzureBlobFileSystem
implements FileSystem {
    public String getScheme() {
        return "abfs";
    }

    public void put(URI target, File source) throws IOException {
        DataLakeFileSystemClient fileSystemClient = this.createClient(target);
        String targetFile0 = target.getPath();
        String targetFile = targetFile0.startsWith("/") ? targetFile0.substring(1) : targetFile0;
        File targetDirectory = new File(targetFile).getParentFile();
        fileSystemClient.createDirectoryIfNotExists(targetDirectory.toString());
        DataLakeFileClient fileClient = fileSystemClient.createFile(targetFile, true);
        fileClient.uploadFromFile(source.toString(), true);
    }

    public void putAll(URI target, File sources) throws IOException {
    }

    public void delete(URI target, boolean recursive) throws IOException {
        DataLakeFileSystemClient fileSystemClient = this.createClient(target);
        String targetFile = target.getPath();
        String targetDirectory = new File(targetFile).getParent();
        DataLakeDirectoryClient directoryClient = fileSystemClient.getDirectoryClient(targetDirectory);
        directoryClient.deleteFileIfExists(targetFile);
        if (recursive) {
            directoryClient.deleteSubdirectoryIfExists(targetFile);
        }
    }

    private DataLakeFileSystemClient createClient(URI uri) {
        String host = uri.getHost();
        String fileSystemName = uri.getUserInfo();
        String endpoint = "https://" + host;
        DefaultAzureCredential defaultCredential = new DefaultAzureCredentialBuilder().build();
        DataLakeServiceClient serviceClient = new DataLakeServiceClientBuilder().credential((TokenCredential)defaultCredential).endpoint(endpoint).buildClient();
        return serviceClient.getFileSystemClient(fileSystemName);
    }
}

