/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import org.everit.json.schema.AbstractFormatValidator;

public class URIFormatValidator
extends AbstractFormatValidator {
    @Override
    public Optional<String> validate(String subject) {
        try {
            new URI(subject);
            return Optional.absent();
        }
        catch (NullPointerException | URISyntaxException e) {
            return Optional.of((Object)String.format("[%s] is not a valid URI", subject));
        }
    }

    @Override
    public String formatName() {
        return "uri";
    }
}

