/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.auth;

import com.dtflys.forest.auth.ForestAuthenticator;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.Base64Utils;
import com.dtflys.forest.utils.StringUtils;

public class BasicAuth
implements ForestAuthenticator {
    private String userInfo;

    public BasicAuth() {
    }

    public BasicAuth(String userInfo) {
        this.userInfo = userInfo;
    }

    public BasicAuth(String username, String password) {
        this.userInfo = username + ":" + password;
    }

    public String userInfo() {
        return this.userInfo;
    }

    public BasicAuth userInfo(String userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    public BasicAuth userInfo(String username, String password) {
        this.userInfo = username + ":" + password;
        return this;
    }

    @Override
    public void enhanceAuthorization(ForestRequest request) {
        String userInfo = this.userInfo;
        if (StringUtils.isEmpty(userInfo)) {
            userInfo = request.getUserInfo();
        }
        if (StringUtils.isNotEmpty(userInfo)) {
            String basic = "Basic " + Base64Utils.encode(userInfo);
            request.addHeader("Authorization", basic);
        }
    }
}

