/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend;

import com.dtflys.forest.backend.HttpExecutor;
import com.dtflys.forest.backend.ResponseHandler;
import com.dtflys.forest.config.AsyncThreadPools;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestFuture;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.http.ForestResponseFactory;
import com.dtflys.forest.reflection.MethodLifeCycleHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;

public class AsyncHttpExecutor<T>
implements HttpExecutor {
    protected final ForestConfiguration configuration;
    protected final HttpExecutor syncExecutor;
    protected final ResponseHandler responseHandler;

    public static int getMaxAsyncThreadSize() {
        return AsyncHttpExecutor.getMaxAsyncThreadSize(ForestConfiguration.configuration());
    }

    public static int getMaxAsyncThreadSize(ForestConfiguration configuration) {
        ThreadPoolExecutor pool = AsyncThreadPools.get(configuration);
        if (pool == null) {
            return -1;
        }
        return pool.getMaximumPoolSize();
    }

    public static int getAsyncThreadSize() {
        return AsyncHttpExecutor.getAsyncThreadSize(ForestConfiguration.configuration());
    }

    public static int getAsyncThreadSize(ForestConfiguration configuration) {
        ThreadPoolExecutor pool = AsyncThreadPools.get(configuration);
        if (pool == null) {
            return -1;
        }
        return pool.getPoolSize();
    }

    public AsyncHttpExecutor(ForestConfiguration configuration, HttpExecutor syncExecutor, ResponseHandler responseHandler) {
        this.configuration = configuration;
        this.syncExecutor = syncExecutor;
        this.responseHandler = responseHandler;
    }

    @Override
    public ForestRequest getRequest() {
        return this.syncExecutor.getRequest();
    }

    @Override
    public void execute(LifeCycleHandler lifeCycleHandler) {
        ThreadPoolExecutor pool = AsyncThreadPools.getOrCreate(this.configuration);
        AsyncTask task = new AsyncTask(this.syncExecutor, lifeCycleHandler);
        CompletableFuture future = CompletableFuture.supplyAsync(task, pool);
        ForestFuture forestFuture = new ForestFuture(this.getRequest(), future);
        this.responseHandler.handleFuture(this.getRequest(), forestFuture);
    }

    @Override
    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    @Override
    public ForestResponseFactory getResponseFactory() {
        return this.syncExecutor.getResponseFactory();
    }

    @Override
    public void close() {
    }

    public static synchronized void closePool() {
        ThreadPoolExecutor pool = AsyncThreadPools.get(ForestConfiguration.configuration());
        if (pool != null) {
            pool.shutdown();
        }
    }

    public static class AsyncTask<T>
    implements Supplier<ForestResponse<T>> {
        private final HttpExecutor executor;
        private final LifeCycleHandler lifeCycleHandler;

        public AsyncTask(HttpExecutor executor, LifeCycleHandler lifeCycleHandler) {
            this.executor = executor;
            this.lifeCycleHandler = lifeCycleHandler;
        }

        public LifeCycleHandler getLifeCycleHandler() {
            return this.lifeCycleHandler;
        }

        @Override
        public ForestResponse get() {
            this.executor.execute(this.lifeCycleHandler);
            if (this.lifeCycleHandler instanceof MethodLifeCycleHandler) {
                ForestResponse result = ((MethodLifeCycleHandler)this.lifeCycleHandler).getResponse();
                return result;
            }
            return null;
        }
    }
}

