/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Optional;

public class SocksAuthenticator
extends Authenticator {
    private static final SocksAuthenticator instance = new SocksAuthenticator();
    private ThreadLocal<PasswordAuthentication> passwordAuthenticationThreadLocal = new ThreadLocal();

    public static SocksAuthenticator getInstance() {
        return instance;
    }

    public void setPasswordAuthenticator(PasswordAuthentication passwordAuthentication) {
        this.passwordAuthenticationThreadLocal.set(passwordAuthentication);
    }

    public void setPasswordAuthenticator(String username, String password) {
        this.setPasswordAuthenticator(new PasswordAuthentication(username, Optional.of(password).orElse("").toCharArray()));
    }

    public void removePasswordAuthenticator() {
        this.passwordAuthenticationThreadLocal.remove();
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return this.passwordAuthenticationThreadLocal.get();
    }

    static {
        Authenticator.setDefault(instance);
    }
}

