/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient;

import com.dtflys.forest.backend.AbstractHttpBackend;
import com.dtflys.forest.backend.ForestConnectionManager;
import com.dtflys.forest.backend.HttpExecutor;
import com.dtflys.forest.backend.httpclient.conn.HttpclientConnectionManager;
import com.dtflys.forest.backend.httpclient.executor.HttpclientExecutor;
import com.dtflys.forest.backend.httpclient.request.HttpclientRequestSender;
import com.dtflys.forest.backend.httpclient.request.SyncHttpclientRequestSender;
import com.dtflys.forest.backend.httpclient.response.HttpclientResponseHandler;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;

public class HttpclientBackend
extends AbstractHttpBackend {
    public static final String NAME = "httpclient";
    private static final String HTTPCLIENT_REQUEST_KEY = "#httpclient_request";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isAllowEncodeBraceInQueryValue() {
        return true;
    }

    @Override
    public HttpExecutor createSyncExecutor(ForestConnectionManager connectionManager, ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        return new HttpclientExecutor(request, HttpclientBackend.getHttpclientResponseHandler(request, lifeCycleHandler), HttpclientBackend.getRequestSender(connectionManager, request));
    }

    private static HttpclientResponseHandler getHttpclientResponseHandler(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        return new HttpclientResponseHandler(request, lifeCycleHandler);
    }

    private static HttpclientRequestSender getRequestSender(ForestConnectionManager connectionManager, ForestRequest request) {
        return new SyncHttpclientRequestSender((HttpclientConnectionManager)connectionManager, request);
    }

    public HttpclientBackend() {
        super(new HttpclientConnectionManager());
    }
}

