/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.body;

import com.dtflys.forest.backend.body.AbstractBodyBuilder;
import com.dtflys.forest.backend.httpclient.body.HttpclientMultipartCommonBody;
import com.dtflys.forest.backend.httpclient.body.HttpclientMultipartFileBody;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.body.NameValueRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.StringUtils;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;

public class HttpclientBodyBuilder<T extends HttpEntityEnclosingRequestBase>
extends AbstractBodyBuilder<T> {
    @Override
    protected void setStringBody(T httpReq, ForestRequest request, String text, String charset, String contentType, boolean mergeCharset) {
        StringEntity entity = new StringEntity(text, charset);
        if (charset == null && mergeCharset) {
            if (!contentType.contains("charset=")) {
                contentType = contentType + "; charset=" + charset;
            } else {
                String[] strs = contentType.split("charset=");
                contentType = strs[0] + " charset=" + charset;
            }
            entity.setContentEncoding(charset);
        }
        entity.setContentType(contentType);
        httpReq.setEntity((HttpEntity)entity);
    }

    private void addMultipart(MultipartEntityBuilder entityBuilder, String name, Object value, String contentType, Charset charset, ForestJsonConverter jsonConverter) {
        if (value == null) {
            return;
        }
        if (StringUtils.isEmpty(contentType)) {
            contentType = "text/plain";
        }
        String text = MappingTemplate.getParameterValue(jsonConverter, value);
        ContentType itemContentType = ContentType.create((String)contentType, (Charset)charset);
        entityBuilder.addTextBody(name, text, itemContentType);
    }

    @Override
    protected void setFileBody(T httpReq, ForestRequest request, Charset charset, String contentType, LifeCycleHandler lifeCycleHandler) {
        String partContentType;
        String name;
        String boundary = request.getBoundary();
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        if (StringUtils.isNotEmpty(boundary)) {
            entityBuilder.setBoundary(boundary);
        }
        ForestJsonConverter jsonConverter = request.getConfiguration().getJsonConverter();
        Charset httpCharset = charset;
        Charset itemCharset = StandardCharsets.UTF_8;
        if (charset != null) {
            itemCharset = charset;
        }
        boolean needSetMode = false;
        for (Object item : request.body()) {
            Object obj;
            if (item instanceof NameValueRequestBody) {
                needSetMode = true;
                NameValueRequestBody nameValueItem = (NameValueRequestBody)item;
                name = nameValueItem.getName();
                Iterator<Map.Entry<String, Object>> value = nameValueItem.getValue();
                partContentType = nameValueItem.getContentType();
                this.addMultipart(entityBuilder, name, value, partContentType, itemCharset, jsonConverter);
                continue;
            }
            if (!(item instanceof ObjectRequestBody) || (obj = ((ObjectRequestBody)item).getObject()) == null) continue;
            needSetMode = true;
            Map<String, Object> attrs = jsonConverter.convertObjectToMap(obj, request);
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String name2 = entry.getKey();
                Object value = entry.getValue();
                this.addMultipart(entityBuilder, name2, value, null, itemCharset, jsonConverter);
            }
        }
        if (needSetMode) {
            entityBuilder.setCharset(httpCharset);
            entityBuilder.setMode(HttpMultipartMode.RFC6532);
        }
        List<ForestMultipart> multiparts = request.getMultiparts();
        for (ForestMultipart multipart : multiparts) {
            name = multipart.getName();
            String fileName = multipart.getOriginalFileName();
            partContentType = multipart.getContentType();
            ContentType ctype = null;
            if (StringUtils.isNotEmpty(partContentType)) {
                ctype = ContentType.create((String)partContentType, (Charset)httpCharset);
            }
            if (ctype == null) {
                String mimeType = URLConnection.guessContentTypeFromName(fileName);
                ctype = mimeType == null ? ContentType.create((String)"multipart/form-data", (Charset)httpCharset) : ContentType.create((String)mimeType);
            }
            Object contentBody = null;
            contentBody = multipart.isFile() ? new HttpclientMultipartFileBody(request, multipart.getFile(), ctype, fileName, lifeCycleHandler) : new HttpclientMultipartCommonBody(request, multipart, ctype, fileName, lifeCycleHandler);
            entityBuilder.addPart(name, (ContentBody)contentBody);
        }
        HttpEntity entity = entityBuilder.build();
        httpReq.setEntity(entity);
    }

    @Override
    protected void setBinaryBody(T httpReq, ForestRequest request, String charset, String contentType, byte[] bytes, boolean mergeCharset) {
        if (StringUtils.isBlank(contentType)) {
            contentType = ContentType.APPLICATION_OCTET_STREAM.toString();
        }
        if (charset == null && mergeCharset) {
            if (!contentType.contains("charset=")) {
                contentType = contentType + "; charset=" + charset;
            } else {
                String[] strs = contentType.split("charset=");
                contentType = strs[0] + " charset=" + charset;
            }
        }
        ContentType ctype = ContentType.create((String)contentType, (String)charset);
        ByteArrayEntity entity = new ByteArrayEntity(bytes, ctype);
        httpReq.setEntity((HttpEntity)entity);
    }
}

