/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.conn;

import com.dtflys.forest.backend.httpclient.conn.HttpContextUtils;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestProxy;
import com.dtflys.forest.http.ForestProxyType;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.ssl.SSLKeyStore;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class ForestSSLConnectionFactory
implements LayeredConnectionSocketFactory {
    public Socket createSocket(HttpContext context) throws IOException {
        ForestRequest<?> currentRequest = HttpContextUtils.getCurrentRequest(context);
        ForestProxy proxy = currentRequest.getProxy();
        if (proxy != null && proxy.getType() == ForestProxyType.SOCKS) {
            return new Socket(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxy.getHost(), proxy.getPort())));
        }
        return SocketFactory.getDefault().createSocket();
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        ForestRequest<?> currentRequest = HttpContextUtils.getCurrentRequest(context);
        ForestProxy proxy = currentRequest.getProxy();
        InetSocketAddress address = proxy != null && proxy.getType() == ForestProxyType.SOCKS ? InetSocketAddress.createUnresolved(host.getHostName(), host.getPort()) : remoteAddress;
        Socket connectSocket = this.getSslConnectionSocketFactory(currentRequest).connectSocket(connectTimeout, socket, host, address, localAddress, context);
        return connectSocket;
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        ForestRequest<?> currentRequest = HttpContextUtils.getCurrentRequest(context);
        Socket connectSocket = this.getSslConnectionSocketFactory(currentRequest).createLayeredSocket(socket, target, port, context);
        return connectSocket;
    }

    private String[][] getSupportedSSLProtocolsAndCipherSuites(ForestRequest request) {
        try {
            SSLSocketFactory sslFactory = request.getSSLSocketFactory();
            SSLSocket socket = (SSLSocket)sslFactory.createSocket();
            String[] protocols = socket.getSupportedProtocols();
            String[] cipherSuites = socket.getSupportedCipherSuites();
            return new String[][]{protocols, cipherSuites};
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    private SSLConnectionSocketFactory getSslConnectionSocketFactory(ForestRequest request) {
        SSLSocketFactory sslSocketFactory = request.getSSLSocketFactory();
        SSLKeyStore keyStore = request.getKeyStore();
        String[][] protocolsAndCipherSuites = this.getSupportedSSLProtocolsAndCipherSuites(request);
        SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslSocketFactory, keyStore == null ? protocolsAndCipherSuites[0] : keyStore.getProtocols(), keyStore == null ? protocolsAndCipherSuites[1] : keyStore.getCipherSuites(), request.hostnameVerifier());
        return factory;
    }
}

