/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.conn;

import com.dtflys.forest.backend.ForestConnectionManager;
import com.dtflys.forest.backend.httpclient.HttpClientProvider;
import com.dtflys.forest.backend.httpclient.conn.ForestConnectionFactory;
import com.dtflys.forest.backend.httpclient.conn.ForestSSLConnectionFactory;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestProxy;
import com.dtflys.forest.http.ForestProxyType;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.TimeUtils;
import java.util.LinkedList;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class HttpclientConnectionManager
implements ForestConnectionManager {
    private DefaultHttpClientProvider defaultHttpClientProvider;
    private PoolingHttpClientConnectionManager tsConnectionManager;
    private boolean inited = false;

    @Override
    public boolean isInitialized() {
        return this.inited;
    }

    @Override
    public synchronized void init(ForestConfiguration configuration) {
        if (!this.inited) {
            try {
                Integer maxConnections = configuration.getMaxConnections() != null ? configuration.getMaxConnections() : 500;
                Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new ForestSSLConnectionFactory()).register("http", (Object)new ForestConnectionFactory()).build();
                this.tsConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                this.tsConnectionManager.setMaxTotal(maxConnections.intValue());
                this.tsConnectionManager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
                this.tsConnectionManager.setValidateAfterInactivity(60);
                this.defaultHttpClientProvider = new DefaultHttpClientProvider();
                this.inited = true;
            }
            catch (Throwable th) {
                throw new ForestRuntimeException(th);
            }
        }
    }

    public HttpClient getHttpClient(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        HttpClient cachedClient;
        ForestConfiguration configuration = request.getConfiguration();
        String key = "hc;" + request.clientKey();
        boolean canCacheClient = request.cacheBackendClient();
        if (canCacheClient && (cachedClient = (HttpClient)configuration.getBackendClient(key)) != null) {
            return cachedClient;
        }
        HttpClientProvider provider = this.defaultHttpClientProvider;
        Object client = request.getBackendClient();
        if (client != null) {
            if (client instanceof HttpClient) {
                return (HttpClient)client;
            }
            if (client instanceof HttpClientProvider) {
                provider = (HttpClientProvider)client;
            } else {
                throw new ForestRuntimeException("[Forest] Backend '" + request.getBackend().getName() + "' does not support client of type '" + client.getClass().getName() + "'");
            }
        }
        HttpClient httpClient = (HttpClient)provider.getClient(request, lifeCycleHandler);
        if (canCacheClient) {
            configuration.putBackendClientToCache(key, httpClient);
        }
        return httpClient;
    }

    @Deprecated
    public static PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager() {
        return null;
    }

    public static class DefaultHttpClientProvider
    implements HttpClientProvider {
        private HttpclientConnectionManager connectionManager;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpClient getClient(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
            if (this.connectionManager == null) {
                DefaultHttpClientProvider defaultHttpClientProvider = this;
                synchronized (defaultHttpClientProvider) {
                    if (this.connectionManager == null) {
                        ForestConfiguration configuration = request.getConfiguration();
                        this.connectionManager = (HttpclientConnectionManager)configuration.getBackendSelector().select("httpclient").getConnectionManager();
                        if (!this.connectionManager.isInitialized()) {
                            this.connectionManager.init(configuration);
                        }
                    }
                }
            }
            HttpClientBuilder builder = HttpClients.custom();
            builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager.tsConnectionManager);
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            Integer timeout = request.getTimeout();
            Integer connectTimeout = request.connectTimeout();
            Integer readTimeout = request.readTimeout();
            if (TimeUtils.isNone(connectTimeout)) {
                connectTimeout = timeout;
            }
            if (TimeUtils.isNone(readTimeout)) {
                readTimeout = timeout;
            }
            configBuilder.setConnectTimeout(connectTimeout.intValue());
            configBuilder.setSocketTimeout(readTimeout.intValue());
            configBuilder.setCookieSpec("ignoreCookies");
            configBuilder.setRedirectsEnabled(false);
            ForestProxy forestProxy = request.getProxy();
            if (forestProxy != null) {
                String username = forestProxy.getUsername();
                String password = forestProxy.getPassword();
                if (forestProxy.getType() == ForestProxyType.HTTP) {
                    HttpHost proxy = new HttpHost(forestProxy.getHost(), forestProxy.getPort());
                    if (StringUtils.isNotEmpty(username) || !forestProxy.getHeaders().isEmpty()) {
                        BasicCredentialsProvider provider = new BasicCredentialsProvider();
                        provider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(username, password));
                        builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
                        ForestHeaderMap proxyHeaders = forestProxy.getHeaders();
                        if (!proxyHeaders.isEmpty()) {
                            LinkedList<BasicHeader> proxyHeaderList = new LinkedList<BasicHeader>();
                            for (Map.Entry<String, String> entry : proxyHeaders.entrySet()) {
                                BasicHeader proxyHeader = new BasicHeader(entry.getKey(), entry.getValue());
                                proxyHeaderList.add(proxyHeader);
                            }
                            builder.setDefaultHeaders(proxyHeaderList);
                        }
                    }
                    configBuilder.setProxy(proxy);
                }
            }
            RequestConfig requestConfig = configBuilder.build();
            return builder.setDefaultRequestConfig(requestConfig).disableContentCompression().build();
        }
    }
}

