/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.logging;

import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.backend.httpclient.body.HttpclientMultipartFileBody;
import com.dtflys.forest.logging.LogBodyMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MinimalField;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class HttpclientLogBodyMessage
implements LogBodyMessage {
    private final HttpEntity entity;

    public HttpclientLogBodyMessage(HttpEntity entity) {
        this.entity = entity;
    }

    private String getLogContentFormBufferedReader(BufferedReader reader) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        LinkedList<String> lines = new LinkedList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        int len = lines.size();
        for (int i = 0; i < len; ++i) {
            builder.append((String)lines.get(i));
            if (i >= len - 1) continue;
            builder.append("\\n");
        }
        String body = builder.toString();
        return body;
    }

    private String getLogContentForStringBody(HttpEntity entity) {
        InputStream in = null;
        try {
            in = entity.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            return this.getLogContentFormBufferedReader(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBodyString() {
        if (this.entity == null) {
            return null;
        }
        Header contentTypeHeader = this.entity.getContentType();
        ContentType contentType = new ContentType(contentTypeHeader.getValue(), StandardCharsets.UTF_8);
        if (contentType.isMultipart()) {
            Class[] paramTypes = new Class[]{};
            Object[] args = new Object[]{};
            List parts = null;
            try {
                Method getMultipartMethod = this.entity.getClass().getDeclaredMethod("getMultipart", paramTypes);
                getMultipartMethod.setAccessible(true);
                Object multipart = getMultipartMethod.invoke((Object)this.entity, args);
                if (multipart != null) {
                    Method getBodyPartsMethod = multipart.getClass().getDeclaredMethod("getBodyParts", paramTypes);
                    getBodyPartsMethod.setAccessible(true);
                    parts = (List)getBodyPartsMethod.invoke(multipart, args);
                }
            }
            catch (NoSuchMethodException getMultipartMethod) {
            }
            catch (IllegalAccessException getMultipartMethod) {
            }
            catch (InvocationTargetException getMultipartMethod) {
                // empty catch block
            }
            Long contentLength = null;
            try {
                contentLength = this.entity.getContentLength();
            }
            catch (Throwable multipart) {
                // empty catch block
            }
            if (parts == null) {
                String result = "[" + this.entity.getContentType().getValue();
                if (contentLength != null) {
                    result = result + "; length=" + contentLength;
                }
                return result + "]";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(this.entity.getContentType().getValue());
            if (contentLength != null) {
                builder.append("; length=").append(contentLength);
            }
            builder.append("] parts:");
            for (FormBodyPart part : parts) {
                ContentBody partBody = part.getBody();
                MinimalField disposition = part.getHeader().getField("Content-Disposition");
                builder.append("\n             -- [").append(disposition.getBody());
                if (partBody instanceof StringBody) {
                    Reader reader = ((StringBody)partBody).getReader();
                    BufferedReader bufferedReader = new BufferedReader(reader);
                    String value = null;
                    try {
                        value = this.getLogContentFormBufferedReader(bufferedReader);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    builder.append("; content-type=\"").append(((StringBody)partBody).getContentType()).append("\"");
                    builder.append("; value=\"").append(value).append("\"]");
                    continue;
                }
                Long length = null;
                length = partBody.getContentLength();
                if (length != null) {
                    builder.append("; length=").append(length);
                }
                if (partBody instanceof HttpclientMultipartFileBody) {
                    builder.append("; content-type=\"").append(((HttpclientMultipartFileBody)partBody).getContentType()).append("\"");
                }
                builder.append("]");
            }
            return builder.toString();
        }
        if (contentType.isBinary()) {
            return "[Binary length=" + this.entity.getContentLength() + "]";
        }
        return this.getLogContentForStringBody(this.entity);
    }
}

