/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.request;

import com.dtflys.forest.backend.httpclient.HttpclientCookie;
import com.dtflys.forest.backend.httpclient.conn.HttpclientConnectionManager;
import com.dtflys.forest.backend.httpclient.logging.HttpclientLogBodyMessage;
import com.dtflys.forest.backend.httpclient.request.HttpclientRequestSender;
import com.dtflys.forest.http.ForestCookies;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestProxy;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.logging.LogConfiguration;
import com.dtflys.forest.logging.LogHeaderMessage;
import com.dtflys.forest.logging.RequestLogMessage;
import com.dtflys.forest.logging.RequestProxyLogMessage;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.cookie.Cookie;

public abstract class AbstractHttpclientRequestSender
implements HttpclientRequestSender {
    protected final HttpclientConnectionManager connectionManager;
    protected final ForestRequest request;

    public AbstractHttpclientRequestSender(HttpclientConnectionManager connectionManager, ForestRequest request) {
        this.connectionManager = connectionManager;
        this.request = request;
    }

    protected <T extends HttpRequestBase> void setLogHeaders(RequestLogMessage logMessage, T httpReq) {
        Header[] headers = httpReq.getAllHeaders();
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            String name = header.getName();
            String value = header.getValue();
            logMessage.addHeader(new LogHeaderMessage(name, value));
        }
    }

    protected <T extends HttpRequestBase> void setLogBody(RequestLogMessage logMessage, T httpReq) {
        HttpEntityEnclosingRequestBase entityEnclosingRequest = (HttpEntityEnclosingRequestBase)httpReq;
        HttpEntity entity = entityEnclosingRequest.getEntity();
        if (entity == null) {
            return;
        }
        HttpclientLogBodyMessage logBodyMessage = new HttpclientLogBodyMessage(entity);
        logMessage.setBody(logBodyMessage);
    }

    private <T extends HttpRequestBase> RequestLogMessage getRequestLogMessage(int retryCount, T httpReq, HttpClient client) {
        RequestLogMessage logMessage = new RequestLogMessage();
        URI uri = httpReq.getURI();
        logMessage.setUri(uri.toASCIIString());
        logMessage.setType(httpReq.getMethod());
        logMessage.setScheme(uri.getScheme());
        logMessage.setRetryCount(retryCount);
        this.setLogHeaders(logMessage, httpReq);
        this.setLogBody(logMessage, httpReq);
        ForestProxy proxy = this.request.getProxy();
        if (proxy != null) {
            RequestProxyLogMessage proxyLogMessage = new RequestProxyLogMessage();
            proxyLogMessage.setType(proxy.getType().name());
            proxyLogMessage.setHost(proxy.getHost());
            proxyLogMessage.setPort(proxy.getPort() + "");
            ForestHeaderMap headers = proxy.getHeaders();
            if (headers != null && !headers.isEmpty()) {
                proxyLogMessage.setHeaders((String[])proxy.getHeaders().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).toArray(String[]::new));
            }
            logMessage.setProxy(proxyLogMessage);
        }
        return logMessage;
    }

    public <T extends HttpRequestBase> void logRequest(int retryCount, T httpReq, HttpClient client) {
        LogConfiguration logConfiguration = this.request.getLogConfiguration();
        if (!logConfiguration.isLogEnabled() || !logConfiguration.isLogRequest()) {
            return;
        }
        RequestLogMessage logMessage = this.getRequestLogMessage(retryCount, httpReq, client);
        logMessage.setRequest(this.request);
        this.request.setRequestLogMessage(logMessage);
        ForestLogHandler logHandler = this.request.getLogConfiguration().getLogHandler();
        if (logHandler != null) {
            logHandler.logRequest(logMessage);
        }
    }

    protected ForestCookies getCookiesFromHttpCookieStore(CookieStore cookieStore) {
        ForestCookies cookies = new ForestCookies();
        for (Cookie httpCookie : cookieStore.getCookies()) {
            HttpclientCookie cookie = new HttpclientCookie(httpCookie);
            cookies.addCookie(cookie);
        }
        return cookies;
    }
}

