/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.request;

import com.dtflys.forest.backend.AbstractHttpExecutor;
import com.dtflys.forest.backend.httpclient.conn.HttpclientConnectionManager;
import com.dtflys.forest.backend.httpclient.request.AbstractHttpclientRequestSender;
import com.dtflys.forest.backend.httpclient.response.HttpclientForestResponseFactory;
import com.dtflys.forest.backend.httpclient.response.HttpclientResponseHandler;
import com.dtflys.forest.exceptions.ForestNetworkException;
import com.dtflys.forest.exceptions.ForestRetryException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.logging.LogConfiguration;
import com.dtflys.forest.logging.ResponseLogMessage;
import java.util.Date;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class SyncHttpclientRequestSender
extends AbstractHttpclientRequestSender {
    private HttpClient client;

    public SyncHttpclientRequestSender(HttpclientConnectionManager connectionManager, ForestRequest request) {
        super(connectionManager, request);
    }

    protected HttpClient getHttpClient(LifeCycleHandler lifeCycleHandler) {
        HttpClient client = this.connectionManager.getHttpClient(this.request, lifeCycleHandler);
        return client;
    }

    public void logResponse(ForestResponse response) {
        LogConfiguration logConfiguration = this.request.getLogConfiguration();
        if (!logConfiguration.isLogEnabled() || response.isLogged()) {
            return;
        }
        response.setLogged(true);
        ResponseLogMessage logMessage = new ResponseLogMessage(response, response.getStatusCode());
        ForestLogHandler logHandler = logConfiguration.getLogHandler();
        if (logHandler != null) {
            if (logConfiguration.isLogResponseStatus()) {
                logHandler.logResponseStatus(logMessage);
            }
            if (logConfiguration.isLogResponseContent()) {
                logHandler.logResponseContent(logMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ForestRequest request, AbstractHttpExecutor executor, HttpclientResponseHandler responseHandler, HttpUriRequest httpRequest, LifeCycleHandler lifeCycleHandler, Date startDate) {
        ForestRetryException retryEx;
        HttpResponse httpResponse = null;
        ForestResponse<?> response = null;
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("REQUEST", (Object)request);
        HttpClientContext httpClientContext = HttpClientContext.adapt((HttpContext)httpContext);
        this.client = this.getHttpClient(lifeCycleHandler);
        HttpclientForestResponseFactory forestResponseFactory = new HttpclientForestResponseFactory();
        try {
            this.logRequest(request.getCurrentRetryCount(), (HttpRequestBase)httpRequest, this.client);
            httpResponse = this.client.execute(httpRequest, (HttpContext)httpClientContext);
        }
        catch (Throwable e) {
            response = forestResponseFactory.createResponse((ForestRequest<?>)request, httpResponse, lifeCycleHandler, e, startDate);
            if (httpRequest.isAborted()) {
                lifeCycleHandler.handleCanceled(request, response);
                return;
            }
            ForestRetryException retryException = new ForestRetryException(e, request, request.getRetryCount(), request.getCurrentRetryCount());
            try {
                request.canRetry(response, retryException);
            }
            catch (Throwable throwable) {
                response = forestResponseFactory.createResponse((ForestRequest<?>)request, httpResponse, lifeCycleHandler, throwable, startDate);
                lifeCycleHandler.handleSyncWithException(request, response, e);
                return;
            }
            response = forestResponseFactory.createResponse((ForestRequest<?>)request, httpResponse, lifeCycleHandler, (Throwable)null, startDate);
            this.logResponse(response);
            executor.execute(lifeCycleHandler);
            return;
        }
        finally {
            if (response == null) {
                response = forestResponseFactory.createResponse((ForestRequest<?>)request, httpResponse, lifeCycleHandler, (Throwable)null, startDate);
            }
            this.logResponse(response);
        }
        if (response == null) {
            response = forestResponseFactory.createResponse((ForestRequest<?>)request, httpResponse, lifeCycleHandler, (Throwable)null, startDate);
        }
        if ((retryEx = request.canRetry(response)) != null && retryEx.isNeedRetry() && !retryEx.isMaxRetryCountReached()) {
            response.close();
            executor.execute(lifeCycleHandler);
            return;
        }
        if (retryEx == null && response.isError()) {
            ForestNetworkException networkException = new ForestNetworkException("", response.getStatusCode(), response);
            ForestRetryException retryException = new ForestRetryException(networkException, request, request.getRetryCount(), request.getCurrentRetryCount());
            try {
                request.canRetry(response, retryException);
            }
            catch (Throwable throwable) {
                responseHandler.handleSync(httpResponse, response);
                return;
            }
            response.close();
            executor.execute(lifeCycleHandler);
            return;
        }
        try {
            responseHandler.handleSync(httpResponse, response);
        }
        catch (Exception ex) {
            if (ex instanceof ForestRuntimeException) {
                throw ex;
            }
            throw new ForestRuntimeException(ex);
        }
    }
}

