/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.response;

import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.ForestProgress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class HttpclientEntity
implements HttpEntity {
    private final ForestRequest request;
    private final HttpEntity entity;
    private final LifeCycleHandler handler;
    private long contentLength = -1L;
    private long readBytes;
    private final long progressStep;
    private long currentStep = 0L;

    public HttpclientEntity(ForestRequest request, HttpEntity entity, LifeCycleHandler handler) {
        this.request = request;
        this.entity = entity;
        this.handler = handler;
        this.progressStep = request.getProgressStep();
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public boolean isChunked() {
        return this.entity.isChunked();
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public Header getContentType() {
        return this.entity.getContentType();
    }

    public Header getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            InputStream in = this.entity.getContent();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.contentLength < 0L) {
                this.contentLength = this.getContentLength();
            }
            ForestProgress progress = new ForestProgress(this.request, this.contentLength);
            try {
                int len;
                byte[] tmp = new byte[4096];
                progress.setBegin(true);
                while ((len = in.read(tmp)) != -1) {
                    this.readBytes += (long)len;
                    progress.setCurrentBytes(this.readBytes);
                    if (this.contentLength >= 0L) {
                        this.currentStep += (long)len;
                        if (this.readBytes == this.contentLength) {
                            progress.setDone(true);
                            this.handler.handleProgress(this.request, progress);
                        } else {
                            while (this.currentStep >= this.progressStep) {
                                this.currentStep -= this.progressStep;
                                progress.setDone(false);
                                this.handler.handleProgress(this.request, progress);
                            }
                        }
                    }
                    progress.setBegin(false);
                    out.write(tmp, 0, len);
                }
                out.flush();
            }
            finally {
                in.close();
            }
            return new ByteArrayInputStream(out.toByteArray());
        }
        return this.entity.getContent();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.entity.writeTo(outputStream);
    }

    public boolean isStreaming() {
        return this.entity.isStreaming();
    }

    public void consumeContent() throws IOException {
        this.entity.consumeContent();
    }
}

