/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.httpclient.response;

import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.utils.GzipUtils;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpclientForestResponse
extends ForestResponse {
    private final HttpResponse httpResponse;
    private final HttpEntity entity;
    private byte[] bytes;

    public HttpclientForestResponse(ForestRequest request, HttpResponse httpResponse, HttpEntity entity, Date requestTime, Date responseTime) {
        super(request, requestTime, responseTime);
        this.httpResponse = httpResponse;
        this.entity = entity;
        if (httpResponse != null) {
            this.setupHeaders();
            StatusLine statusLine = httpResponse.getStatusLine();
            this.statusCode = statusLine.getStatusCode();
            this.reasonPhrase = statusLine.getReasonPhrase();
            if (entity != null) {
                Header type = entity.getContentType();
                if (type != null) {
                    this.contentType = new ContentType(type.getValue(), StandardCharsets.UTF_8);
                }
                this.setupContentEncoding();
                this.setupResponseCharset();
                this.setupGzip();
                this.setupContent();
                this.contentLength = entity.getContentLength();
            } else {
                this.bytes = new byte[0];
                this.content = "";
            }
        } else {
            this.statusCode = -1;
        }
    }

    private void setupContentEncoding() {
        Header contentEncodingHeader = this.entity.getContentEncoding();
        if (contentEncodingHeader != null) {
            this.contentEncoding = contentEncodingHeader.getValue();
        }
    }

    private void setupResponseCharset() {
        if (StringUtils.isNotBlank(this.request.getResponseEncode())) {
            this.charset = this.request.getResponseEncode();
        } else if (this.contentType != null) {
            this.charset = this.contentType.getCharset().name();
        } else if (this.contentEncoding != null) {
            try {
                Charset.forName(this.contentEncoding);
                this.charset = this.contentEncoding;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void setupContent() {
        if (this.content == null) {
            Class<?> resultClass = ReflectUtils.toClass(this.request.getLifeCycleHandler().getResultType());
            if (this.request.isDownloadFile() || InputStream.class.isAssignableFrom(this.request.getMethod().getReturnClass()) || resultClass != null && InputStream.class.isAssignableFrom(resultClass) || this.contentType != null && this.contentType.canReadAsBinaryStream()) {
                StringBuilder builder = new StringBuilder();
                builder.append("[stream content-type: ").append(this.contentType == null ? "undefined" : this.contentType);
                if (this.contentEncoding != null) {
                    builder.append("; encoding: ").append(this.contentEncoding);
                }
                builder.append("; length: ").append(this.contentLength).append("]");
                this.content = builder.toString();
            } else {
                this.content = this.readContentAsString();
            }
        }
    }

    private void setupGzip() {
        this.isGzip = this.contentEncoding != null && !this.request.isDecompressResponseGzipEnabled() ? GzipUtils.isGzip(this.contentEncoding) : true;
    }

    private void setupHeaders() {
        HeaderIterator it;
        if (this.httpResponse != null && (it = this.httpResponse.headerIterator()) != null) {
            while (it.hasNext()) {
                Header header = it.nextHeader();
                this.headers.addHeader(header.getName(), header.getValue());
            }
        }
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public boolean isReceivedResponseData() {
        return this.entity != null || this.bytes != null;
    }

    private String readContentAsString() {
        try {
            this.bytes = this.getByteArray();
            String string = this.byteToString(this.bytes);
            return string;
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public InputStream getInputStream() throws Exception {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.getByteArray());
        }
        return this.entity.getContent();
    }

    @Override
    public byte[] getByteArray() throws IOException {
        if (this.bytes == null) {
            if (this.entity == null) {
                return null;
            }
            try {
                this.bytes = EntityUtils.toByteArray((HttpEntity)this.entity);
            }
            finally {
                this.close();
            }
        }
        return this.bytes;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.httpResponse instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)this.httpResponse).close();
            }
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
        finally {
            this.closed = true;
        }
    }
}

