/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3;

import com.dtflys.forest.backend.AbstractHttpBackend;
import com.dtflys.forest.backend.ForestConnectionManager;
import com.dtflys.forest.backend.HttpExecutor;
import com.dtflys.forest.backend.okhttp3.conn.OkHttp3ConnectionManager;
import com.dtflys.forest.backend.okhttp3.executor.OkHttp3Executor;
import com.dtflys.forest.backend.okhttp3.response.OkHttp3ResponseHandler;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;

public class OkHttp3Backend
extends AbstractHttpBackend {
    public static final String NAME = "okhttp3";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isAllowEncodeBraceInQueryValue() {
        return false;
    }

    public OkHttp3Backend() {
        super(new OkHttp3ConnectionManager());
    }

    @Override
    public HttpExecutor createSyncExecutor(ForestConnectionManager connectionManager, ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        return new OkHttp3Executor(request, (OkHttp3ConnectionManager)connectionManager, this.getOkHttp3ResponseHandler(request, lifeCycleHandler));
    }

    private OkHttp3ResponseHandler getOkHttp3ResponseHandler(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        return new OkHttp3ResponseHandler(request, lifeCycleHandler);
    }
}

