/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.conn;

import com.dtflys.forest.backend.ForestConnectionManager;
import com.dtflys.forest.backend.SocksAuthenticator;
import com.dtflys.forest.backend.okhttp3.OkHttpClientProvider;
import com.dtflys.forest.backend.okhttp3.response.OkHttpResponseBody;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestProtocol;
import com.dtflys.forest.http.ForestProxy;
import com.dtflys.forest.http.ForestProxyType;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.ssl.ForestX509TrustManager;
import com.dtflys.forest.ssl.SSLKeyStore;
import com.dtflys.forest.ssl.TrustAllManager;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.TimeUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttp3ConnectionManager
implements ForestConnectionManager {
    private ConnectionPool pool;
    private DefaultOkHttpClientProvider defaultOkHttpClientProvider;
    private boolean inited = false;
    private static final List<Protocol> HTTP_1_0 = Arrays.asList(Protocol.HTTP_1_0, Protocol.HTTP_1_1);
    private static final List<Protocol> HTTP_1_1 = Arrays.asList(Protocol.HTTP_1_1);
    private static final List<Protocol> HTTP_2 = Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1);
    private static final Map<ForestProtocol, List<Protocol>> PROTOCOL_VERSION_MAP = new HashMap<ForestProtocol, List<Protocol>>();
    private static final TrustAllManager DEFAULT_TRUST_MANAGER = new TrustAllManager();

    public X509TrustManager getX509TrustManager(ForestRequest request) {
        try {
            SSLKeyStore sslKeyStore = request.getKeyStore();
            if (sslKeyStore == null || sslKeyStore.getTrustStore() == null || sslKeyStore.getInputStream() == null) {
                return DEFAULT_TRUST_MANAGER;
            }
            return new ForestX509TrustManager(request.getKeyStore());
        }
        catch (Exception e) {
            throw new ForestRuntimeException(e);
        }
    }

    private List<Protocol> getProtocols(ForestRequest request) {
        ForestProtocol protocol = Optional.ofNullable(request.getProtocol()).orElse(ForestProtocol.HTTP_1_0);
        return PROTOCOL_VERSION_MAP.get((Object)protocol);
    }

    public OkHttpClient getClient(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        OkHttpClient cachedClient;
        boolean canCacheClient;
        ForestConfiguration configuration = request.getConfiguration();
        String key = "ok;" + request.clientKey();
        boolean bl = canCacheClient = request.cacheBackendClient() && !request.isDownloadFile();
        if (canCacheClient && (cachedClient = (OkHttpClient)configuration.getBackendClient(key)) != null) {
            return cachedClient;
        }
        OkHttpClientProvider provider = this.defaultOkHttpClientProvider;
        Object client = request.getBackendClient();
        if (client != null) {
            if (client instanceof OkHttpClient) {
                return (OkHttpClient)client;
            }
            if (client instanceof OkHttpClientProvider) {
                provider = (OkHttpClientProvider)client;
            } else {
                throw new ForestRuntimeException("[Forest] Backend '" + request.getBackend().getName() + "' does not support client of type '" + client.getClass().getName() + "'");
            }
        }
        OkHttpClient newClient = (OkHttpClient)provider.getClient(request, lifeCycleHandler);
        if (canCacheClient) {
            configuration.putBackendClientToCache(key, newClient);
        }
        return newClient;
    }

    @Override
    public boolean isInitialized() {
        return this.inited;
    }

    @Override
    public synchronized void init(ForestConfiguration configuration) {
        if (!this.inited) {
            this.pool = new ConnectionPool();
            this.defaultOkHttpClientProvider = new DefaultOkHttpClientProvider();
            this.inited = true;
        }
    }

    public ConnectionPool getOkHttpPool() {
        return this.pool;
    }

    static {
        PROTOCOL_VERSION_MAP.put(ForestProtocol.HTTP_1_0, HTTP_1_0);
        PROTOCOL_VERSION_MAP.put(ForestProtocol.HTTP_1_1, HTTP_1_1);
        PROTOCOL_VERSION_MAP.put(ForestProtocol.HTTP_2, HTTP_2);
    }

    public static class DefaultOkHttpClientProvider
    implements OkHttpClientProvider {
        private OkHttp3ConnectionManager connectionManager;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OkHttpClient getClient(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
            if (this.connectionManager == null) {
                DefaultOkHttpClientProvider defaultOkHttpClientProvider = this;
                synchronized (defaultOkHttpClientProvider) {
                    if (this.connectionManager == null) {
                        ForestConfiguration configuration = request.getConfiguration();
                        this.connectionManager = (OkHttp3ConnectionManager)configuration.getBackendSelector().select("okhttp3").getConnectionManager();
                        if (!this.connectionManager.isInitialized()) {
                            this.connectionManager.init(configuration);
                        }
                    }
                }
            }
            Integer timeout = request.getTimeout();
            Integer connectTimeout = TimeUtils.isNone(request.connectTimeout()) ? timeout : request.connectTimeout();
            Integer readTimeout = TimeUtils.isNone(request.readTimeout()) ? timeout : request.readTimeout();
            Integer writeTimeout = TimeUtils.isNone(request.readTimeout()) ? timeout : request.readTimeout();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(this.connectionManager.pool).connectTimeout((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS).readTimeout((long)readTimeout.intValue(), TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeout.intValue(), TimeUnit.MILLISECONDS).protocols(this.connectionManager.getProtocols(request)).followRedirects(false).followSslRedirects(false);
            ForestProxy proxy = request.getProxy();
            if (proxy != null) {
                String username = proxy.getUsername();
                String password = proxy.getPassword();
                Proxy.Type type = proxy.getType() == ForestProxyType.SOCKS ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
                Proxy okProxy = new Proxy(type, new InetSocketAddress(proxy.getHost(), proxy.getPort()));
                builder.proxy(okProxy);
                if (type == Proxy.Type.HTTP && (StringUtils.isNotEmpty(username) || !proxy.getHeaders().isEmpty())) {
                    builder.proxyAuthenticator((route, response) -> {
                        Request.Builder proxyBuilder = response.request().newBuilder();
                        Charset charset = StringUtils.isNotEmpty(proxy.getCharset()) ? Charset.forName(proxy.getCharset()) : null;
                        ForestHeaderMap proxyHeaders = proxy.getHeaders();
                        if (!proxyHeaders.isEmpty()) {
                            for (Map.Entry<String, String> entry : proxyHeaders.entrySet()) {
                                proxyBuilder.addHeader(entry.getKey(), entry.getValue());
                            }
                        }
                        if (!proxyHeaders.containsKey("Proxy-Authorization")) {
                            String credential = charset != null ? Credentials.basic((String)username, (String)password, (Charset)charset) : Credentials.basic((String)username, (String)password);
                            proxyBuilder.addHeader("Proxy-Authorization", credential);
                        }
                        proxyBuilder.removeHeader("User-Agent");
                        proxyBuilder.removeHeader("Proxy-Connection");
                        return proxyBuilder.build();
                    });
                } else if (type == Proxy.Type.SOCKS) {
                    builder.addInterceptor(chain -> {
                        boolean hasProxyAuthenticator = false;
                        if (StringUtils.isNotEmpty(username)) {
                            SocksAuthenticator.getInstance().setPasswordAuthenticator(username, password);
                            hasProxyAuthenticator = true;
                        }
                        try {
                            Response response = chain.proceed(chain.request());
                            return response;
                        }
                        finally {
                            if (hasProxyAuthenticator) {
                                SocksAuthenticator.getInstance().removePasswordAuthenticator();
                            }
                        }
                    });
                }
            }
            if (request.isSSL()) {
                SSLSocketFactory sslSocketFactory = request.getSSLSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, this.connectionManager.getX509TrustManager(request)).hostnameVerifier(request.hostnameVerifier());
            }
            if (request.getOnProgress() != null) {
                builder.addNetworkInterceptor(chain -> {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new OkHttpResponseBody(request, response.body(), lifeCycleHandler)).build();
                });
            }
            OkHttpClient newClient = builder.build();
            return newClient;
        }
    }
}

