/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.executor;

import com.dtflys.forest.backend.BodyBuilder;
import com.dtflys.forest.backend.HttpExecutor;
import com.dtflys.forest.backend.ResponseHandler;
import com.dtflys.forest.backend.okhttp3.body.OkHttp3BodyBuilder;
import com.dtflys.forest.backend.okhttp3.conn.OkHttp3ConnectionManager;
import com.dtflys.forest.backend.okhttp3.logging.OkHttp3LogBodyMessage;
import com.dtflys.forest.backend.okhttp3.response.OkHttp3ForestResponseFactory;
import com.dtflys.forest.backend.okhttp3.response.OkHttp3ResponseFuture;
import com.dtflys.forest.backend.okhttp3.response.OkHttp3ResponseHandler;
import com.dtflys.forest.backend.url.QueryableURLBuilder;
import com.dtflys.forest.backend.url.URLBuilder;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestNetworkException;
import com.dtflys.forest.exceptions.ForestRetryException;
import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRequestType;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.http.ForestResponseFactory;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.logging.LogConfiguration;
import com.dtflys.forest.logging.LogHeaderMessage;
import com.dtflys.forest.logging.RequestLogMessage;
import com.dtflys.forest.logging.RequestProxyLogMessage;
import com.dtflys.forest.logging.ResponseLogMessage;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Date;
import java.util.List;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttp3Executor
implements HttpExecutor {
    private static final BodyBuilder BODY_BUILDER = new OkHttp3BodyBuilder();
    private static final URLBuilder URL_BUILDER = new QueryableURLBuilder();
    protected final ForestRequest request;
    private final OkHttp3ConnectionManager connectionManager;
    private final OkHttp3ResponseHandler okHttp3ResponseHandler;
    private Call call;

    protected RequestLogMessage buildRequestMessage(int retryCount, Request okRequest) {
        RequestLogMessage message = new RequestLogMessage();
        HttpUrl url = okRequest.url();
        String scheme = url.scheme().toUpperCase();
        String uri = url.toString();
        String method = okRequest.method();
        message.setUri(uri);
        message.setType(method);
        message.setScheme(scheme);
        message.setRetryCount(retryCount);
        this.setLogHeaders(message, okRequest);
        this.setLogBody(message, okRequest);
        return message;
    }

    protected void setLogHeaders(RequestLogMessage message, Request okRequest) {
        Headers headers = okRequest.headers();
        for (int i = 0; i < headers.size(); ++i) {
            String name = headers.name(i);
            String value = headers.value(i);
            message.addHeader(new LogHeaderMessage(name, value));
        }
    }

    protected void setLogBody(RequestLogMessage message, Request okRequest) {
        RequestBody requestBody = okRequest.body();
        OkHttp3LogBodyMessage logBodyMessage = new OkHttp3LogBodyMessage(requestBody);
        message.setBody(logBodyMessage);
    }

    public void logRequest(int retryCount, Request okRequest, OkHttpClient okHttpClient) {
        LogConfiguration logConfiguration = this.request.getLogConfiguration();
        if (!logConfiguration.isLogEnabled() || !logConfiguration.isLogRequest()) {
            return;
        }
        RequestLogMessage logMessage = this.buildRequestMessage(retryCount, okRequest);
        logMessage.setRequest(this.request);
        logMessage.setRetryCount(retryCount);
        Proxy proxy = okHttpClient.proxy();
        if (proxy != null) {
            RequestProxyLogMessage proxyLogMessage = new RequestProxyLogMessage();
            SocketAddress address = proxy.address();
            if (address instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                proxyLogMessage.setType(this.request.getProxy().getType().name());
                proxyLogMessage.setHost(inetSocketAddress.getHostString());
                proxyLogMessage.setPort(inetSocketAddress.getPort() + "");
                logMessage.setProxy(proxyLogMessage);
            }
        }
        this.request.setRequestLogMessage(logMessage);
        logConfiguration.getLogHandler().logRequest(logMessage);
    }

    public void logResponse(ForestResponse response) {
        LogConfiguration logConfiguration = this.request.getLogConfiguration();
        if (!logConfiguration.isLogEnabled() || response.isLogged()) {
            return;
        }
        response.setLogged(true);
        ResponseLogMessage logMessage = new ResponseLogMessage(response, response.getStatusCode());
        ForestLogHandler logHandler = logConfiguration.getLogHandler();
        if (logHandler != null) {
            if (logConfiguration.isLogResponseStatus()) {
                logHandler.logResponseStatus(logMessage);
            }
            if (logConfiguration.isLogResponseContent()) {
                logHandler.logResponseContent(logMessage);
            }
        }
    }

    public OkHttp3Executor(ForestRequest request, OkHttp3ConnectionManager connectionManager, OkHttp3ResponseHandler okHttp3ResponseHandler) {
        this.request = request;
        this.connectionManager = connectionManager;
        this.okHttp3ResponseHandler = okHttp3ResponseHandler;
    }

    protected OkHttpClient getClient(ForestRequest request, LifeCycleHandler lifeCycleHandler) {
        return this.connectionManager.getClient(request, lifeCycleHandler);
    }

    protected void prepareHeaders(Request.Builder builder) {
        ForestJsonConverter jsonConverter = this.request.getConfiguration().getJsonConverter();
        List<RequestNameValue> headerList = this.request.getHeaderNameValueList();
        String contentType = this.request.getContentType();
        String contentEncoding = this.request.getContentEncoding();
        String contentTypeHeaderName = "Content-Type";
        String contentEncodingHeaderName = "Content-Encoding";
        if (headerList != null && !headerList.isEmpty()) {
            for (RequestNameValue nameValue : headerList) {
                String name = nameValue.getName();
                if ("Content-Type".equalsIgnoreCase(name)) {
                    contentTypeHeaderName = name;
                    continue;
                }
                if ("Content-Encoding".equalsIgnoreCase(name)) {
                    contentEncodingHeaderName = name;
                    continue;
                }
                builder.addHeader(name, MappingTemplate.getParameterValue(jsonConverter, nameValue.getValue()));
            }
        }
        if (StringUtils.isNotEmpty(contentType)) {
            builder.addHeader(contentTypeHeaderName, contentType);
        }
        if (StringUtils.isNotEmpty(contentEncoding)) {
            builder.addHeader(contentEncodingHeaderName, contentEncoding);
        }
    }

    protected void prepareMethodAndBody(Request.Builder builder, LifeCycleHandler lifeCycleHandler) {
        ForestRequestType type;
        ForestRequestType forestRequestType = type = this.request.getType() == null ? ForestRequestType.GET : this.request.getType();
        if (type.isNeedBody()) {
            BODY_BUILDER.buildBody(builder, this.request, lifeCycleHandler);
        } else {
            builder.method(type.getName(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LifeCycleHandler lifeCycleHandler, int retryCount) {
        OkHttpClient okHttpClient = this.getClient(this.request, lifeCycleHandler);
        URLBuilder urlBuilder = URL_BUILDER;
        String url = urlBuilder.buildUrl(this.request);
        Request.Builder builder = new Request.Builder().url(url);
        this.prepareMethodAndBody(builder, lifeCycleHandler);
        this.prepareHeaders(builder);
        Request okRequest = builder.build();
        this.call = okHttpClient.newCall(okRequest);
        OkHttp3ForestResponseFactory factory = new OkHttp3ForestResponseFactory();
        this.logRequest(retryCount, okRequest, okHttpClient);
        Date startDate = new Date();
        Response okResponse = null;
        ForestResponse<?> response = null;
        try {
            this.request.pool().awaitRequest(this.request);
            okResponse = this.call.execute();
        }
        catch (Throwable e) {
            response = factory.createResponse(this.request, null, lifeCycleHandler, e, startDate);
            if (e instanceof IOException && "Canceled".equals(e.getMessage())) {
                lifeCycleHandler.handleCanceled(this.request, response);
                return;
            }
            ForestRetryException retryException = new ForestRetryException(e, this.request, this.request.getMaxRetryCount(), retryCount);
            try {
                this.request.canRetry(response, retryException);
            }
            catch (Throwable throwable) {
                response = factory.createResponse(this.request, null, lifeCycleHandler, throwable, startDate);
                this.logResponse(response);
                lifeCycleHandler.handleSyncWithException(this.request, response, throwable);
                return;
            }
            response = factory.createResponse(this.request, null, lifeCycleHandler, e, startDate);
            this.logResponse(response);
            this.execute(lifeCycleHandler, retryCount + 1);
            return;
        }
        finally {
            this.request.pool().finish(this.request);
            if (response == null) {
                response = factory.createResponse((ForestRequest<?>)this.request, okResponse, lifeCycleHandler, (Throwable)null, startDate);
            }
            this.logResponse(response);
        }
        ForestRetryException retryEx = this.request.canRetry(response);
        if (retryEx != null && retryEx.isNeedRetry() && !retryEx.isMaxRetryCountReached()) {
            response.close();
            this.execute(lifeCycleHandler, retryCount + 1);
            return;
        }
        if (retryEx == null && response.isError()) {
            this.retryOrDoError(response, okResponse, null, lifeCycleHandler, retryCount);
            return;
        }
        this.okHttp3ResponseHandler.handleSync(okResponse, response);
    }

    private void retryOrDoError(ForestResponse response, Response okResponse, OkHttp3ResponseFuture future, LifeCycleHandler lifeCycleHandler, int retryCount) {
        ForestNetworkException networkException = new ForestNetworkException(okResponse.message(), okResponse.code(), response);
        ForestRetryException retryException = new ForestRetryException(networkException, this.request, this.request.getRetryCount(), retryCount);
        try {
            this.request.canRetry(response, retryException);
        }
        catch (Throwable throwable) {
            if (future != null) {
                future.failed(new ForestNetworkException(okResponse.message(), okResponse.code(), response));
            }
            this.logResponse(response);
            this.okHttp3ResponseHandler.handleSync(okResponse, response);
            return;
        }
        response.close();
        this.execute(lifeCycleHandler, retryCount + 1);
    }

    @Override
    public ForestRequest getRequest() {
        return this.request;
    }

    @Override
    public void execute(LifeCycleHandler lifeCycleHandler) {
        this.execute(lifeCycleHandler, 0);
    }

    @Override
    public ResponseHandler getResponseHandler() {
        return this.okHttp3ResponseHandler;
    }

    @Override
    public ForestResponseFactory getResponseFactory() {
        return new OkHttp3ForestResponseFactory();
    }

    @Override
    public void close() {
        if (this.call != null) {
            this.call.cancel();
        }
    }
}

