/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.logging;

import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.logging.LogBodyMessage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class OkHttp3LogBodyMessage
implements LogBodyMessage {
    private final RequestBody requestBody;

    public OkHttp3LogBodyMessage(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLogContentForStringBody(RequestBody requestBody) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Sink sink = Okio.sink((OutputStream)out);
        BufferedSink bufferedSink = Okio.buffer((Sink)sink);
        try {
            requestBody.writeTo(bufferedSink);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufferedSink.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            LinkedList<String> lines = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            int len = lines.size();
            for (int i = 0; i < len; ++i) {
                builder.append((String)lines.get(i));
                if (i >= len - 1) continue;
                builder.append("\\n");
            }
            return builder.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBodyString() {
        if (this.requestBody == null) {
            return null;
        }
        MediaType mediaType = this.requestBody.contentType();
        if (mediaType == null) {
            return this.getLogContentForStringBody(this.requestBody);
        }
        ContentType contentType = new ContentType(mediaType.toString(), StandardCharsets.UTF_8);
        if (contentType.isMultipart()) {
            MultipartBody multipartBody = (MultipartBody)this.requestBody;
            String boundary = multipartBody.boundary();
            Long contentLength = null;
            try {
                contentLength = multipartBody.contentLength();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StringBuilder builder = new StringBuilder();
            builder.append("[").append("boundary=").append(boundary);
            if (contentLength != null) {
                builder.append("; length=").append(contentLength);
            }
            builder.append("] parts:");
            List parts = multipartBody.parts();
            for (MultipartBody.Part part : parts) {
                RequestBody partBody = part.body();
                List disposition = part.headers().values("Content-Disposition");
                builder.append("\n             -- [").append((String)disposition.get(0));
                MediaType partMediaType = partBody.contentType();
                if (partMediaType == null) {
                    builder.append("; content-type=\"").append(partBody.contentType()).append("\"");
                    builder.append("; value=\"").append(this.getLogContentForStringBody(partBody)).append("\"]");
                    continue;
                }
                Long length = null;
                try {
                    length = partBody.contentLength();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (length != null) {
                    builder.append("; length=").append(length);
                }
                builder.append("; content-type=\"").append(partBody.contentType()).append("\"");
                builder.append("]");
            }
            return builder.toString();
        }
        if (contentType.isBinary()) {
            try {
                return "[Binary length=" + this.requestBody.contentLength() + "]";
            }
            catch (IOException e) {
                throw new ForestRuntimeException(e);
            }
        }
        return this.getLogContentForStringBody(this.requestBody);
    }
}

