/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.response;

import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.utils.GzipUtils;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttp3ForestResponse
extends ForestResponse {
    private final Response okResponse;
    private final ResponseBody body;
    private byte[] bytes;

    public OkHttp3ForestResponse(ForestRequest request, Response okResponse, Date requestTime, Date responseTime) {
        super(request, requestTime, responseTime);
        this.okResponse = okResponse;
        if (okResponse == null) {
            this.body = null;
            this.statusCode = null;
            return;
        }
        this.body = okResponse.body();
        this.statusCode = okResponse.code();
        this.reasonPhrase = okResponse.message();
        this.setupHeaders();
        this.setupContentEncoding();
        this.setupGzip();
        if (this.body == null) {
            return;
        }
        this.setupContentTypeAndCharset();
        this.setupContent();
        this.contentLength = this.body.contentLength();
    }

    private void setupContent() {
        if (this.request.isDownloadFile() || InputStream.class.isAssignableFrom(this.request.getMethod().getReturnClass()) || InputStream.class.isAssignableFrom(ReflectUtils.toClass(this.request.getLifeCycleHandler().getResultType())) || this.contentType != null && this.contentType.canReadAsBinaryStream()) {
            StringBuilder builder = new StringBuilder();
            builder.append("[stream content-type: ").append(this.contentType == null ? "undefined" : this.contentType.toString());
            if (this.contentEncoding != null) {
                builder.append("; content-encoding: ").append(this.contentEncoding);
            }
            if (this.charset != null) {
                builder.append("; charset: ").append(this.charset);
            }
            builder.append("; length: ").append(this.contentLength).append("]");
            this.content = builder.toString();
        } else {
            this.content = this.readContentAsString();
        }
    }

    private void setupGzip() {
        this.isGzip = this.contentEncoding != null && !this.request.isDecompressResponseGzipEnabled() ? GzipUtils.isGzip(this.contentEncoding) : true;
    }

    private String readContentAsString() {
        try {
            this.bytes = this.getByteArray();
            if (this.bytes == null) {
                return null;
            }
            return this.byteToString(this.bytes);
        }
        catch (Exception e) {
            throw new ForestRuntimeException(e);
        }
    }

    private void setupHeaders() {
        if (this.okResponse != null) {
            Headers hs = this.okResponse.headers();
            Map hsMap = hs.toMultimap();
            for (Map.Entry entry : hsMap.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (String value : values) {
                    this.headers.addHeader(name, value);
                }
            }
        }
    }

    private void setupContentTypeAndCharset() {
        MediaType mediaType = this.body.contentType();
        if (mediaType != null) {
            String type = mediaType.type();
            String subType = mediaType.subtype();
            this.contentType = new ContentType(type, subType);
            Charset charset = mediaType.charset();
            if (charset != null) {
                this.charset = charset.name();
                return;
            }
        }
        this.setupResponseCharset();
    }

    private void setupResponseCharset() {
        if (StringUtils.isNotBlank(this.request.getResponseEncode())) {
            this.charset = this.request.getResponseEncode();
        } else if (this.contentType != null) {
            this.charset = this.contentType.getCharsetName();
        } else if (this.contentEncoding != null) {
            try {
                Charset.forName(this.contentEncoding);
                this.charset = this.contentEncoding;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void setupContentEncoding() {
        if (StringUtils.isEmpty(this.contentEncoding)) {
            this.contentEncoding = this.okResponse.header("Content-Encoding");
        }
    }

    @Override
    public InputStream getInputStream() throws Exception {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.getByteArray());
        }
        return this.body.byteStream();
    }

    @Override
    public boolean isReceivedResponseData() {
        return this.body != null;
    }

    @Override
    public byte[] getByteArray() throws Exception {
        if (this.bytes == null) {
            if (this.body == null) {
                return null;
            }
            try {
                this.bytes = this.body.bytes();
            }
            finally {
                this.close();
            }
        }
        return this.bytes;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (Throwable th) {
                throw new ForestRuntimeException(th);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

