/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.backend.okhttp3.response;

import com.dtflys.forest.handler.LifeCycleHandler;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.utils.ForestProgress;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class OkHttpResponseBody
extends ResponseBody {
    private final ForestRequest request;
    private final ResponseBody responseBody;
    private final LifeCycleHandler handler;
    private BufferedSource bufferedSource;
    private long contentLength = -1L;
    private final long progressStep;
    private long currentStep = 0L;

    public OkHttpResponseBody(ForestRequest request, ResponseBody responseBody, LifeCycleHandler handler) {
        this.request = request;
        this.responseBody = responseBody;
        this.handler = handler;
        this.progressStep = request.getProgressStep();
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        if (this.contentLength < 0L) {
            this.contentLength = this.responseBody.contentLength();
        }
        return this.contentLength;
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    public void close() {
        super.close();
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long readBytes;
            final AtomicReference<ForestProgress> progressReference;
            final Boolean[] isBegin;
            {
                this.readBytes = 0L;
                this.progressReference = new AtomicReference<Object>(null);
                this.isBegin = new Boolean[]{null};
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                this.isBegin[0] = this.isBegin[0] == null ? Boolean.valueOf(true) : Boolean.valueOf(false);
                long totalLength = OkHttpResponseBody.this.contentLength();
                long bytesRead = super.read(sink, byteCount);
                ForestProgress progress = Optional.ofNullable(this.progressReference.get()).orElseGet(() -> {
                    ForestProgress prg = new ForestProgress(OkHttpResponseBody.this.request, totalLength);
                    this.progressReference.set(prg);
                    return prg;
                });
                if (progress.isDone()) {
                    return bytesRead;
                }
                progress.setBegin(this.isBegin[0]);
                if (totalLength >= 0L) {
                    long currReadBytes = bytesRead != -1L ? bytesRead : 0L;
                    this.readBytes += currReadBytes;
                    progress.setCurrentBytes(this.readBytes);
                    OkHttpResponseBody.this.currentStep += currReadBytes;
                    if (this.readBytes == totalLength) {
                        progress.setDone(true);
                        OkHttpResponseBody.this.handler.handleProgress(OkHttpResponseBody.this.request, progress);
                    } else {
                        while (OkHttpResponseBody.this.currentStep >= OkHttpResponseBody.this.progressStep) {
                            OkHttpResponseBody.this.currentStep = OkHttpResponseBody.this.currentStep - OkHttpResponseBody.this.progressStep;
                            progress.setDone(false);
                            OkHttpResponseBody.this.handler.handleProgress(OkHttpResponseBody.this.request, progress);
                        }
                    }
                }
                return bytesRead;
            }
        };
    }
}

