/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.config;

import com.dtflys.forest.backend.AsyncAbortPolicy;
import com.dtflys.forest.config.ForestConfiguration;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncThreadPools {
    public static final Integer DEFAULT_MAX_THREAD_SIZE = 200;
    public static final Integer DEFAULT_MAX_QUEUE_SIZE = 100;
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private static final AsyncAbortPolicy DEFAULT_ASYNC_REQUEST_REJECT_POLICY = new AsyncAbortPolicy();

    private static ThreadPoolExecutor createAsyncThreadPool(ForestConfiguration configuration) {
        Integer maxAsyncThreadSize = configuration.getMaxAsyncThreadSize();
        Integer maxQueueSize = configuration.getMaxAsyncQueueSize();
        int threadSize = maxAsyncThreadSize != null ? maxAsyncThreadSize : DEFAULT_MAX_THREAD_SIZE;
        int queueSize = maxQueueSize == null ? DEFAULT_MAX_QUEUE_SIZE : maxQueueSize;
        LinkedBlockingQueue<Runnable> queue = queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new SynchronousQueue();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(threadSize, threadSize, 0L, TimeUnit.MINUTES, queue, tf -> {
            Thread thread = new Thread(tf, "forest-async-" + threadCount.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }, (r, executor) -> (configuration.getAsyncRejectPolicy() != null ? configuration.getAsyncRejectPolicy() : DEFAULT_ASYNC_REQUEST_REJECT_POLICY).rejectedExecution(r, executor));
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor getOrCreate(ForestConfiguration configuration) {
        ThreadPoolExecutor pool = configuration.asyncPool;
        if (pool == null) {
            Object object = configuration.ASYNC_POOL_LOCK;
            synchronized (object) {
                pool = configuration.asyncPool;
                if (pool == null) {
                    configuration.asyncPool = pool = AsyncThreadPools.createAsyncThreadPool(configuration);
                }
            }
        }
        return pool;
    }

    public static ThreadPoolExecutor get(ForestConfiguration configuration) {
        return configuration.asyncPool;
    }
}

