/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.config;

import com.dtflys.forest.ForestGenericClient;
import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.backend.HttpBackendSelector;
import com.dtflys.forest.callback.AddressSource;
import com.dtflys.forest.callback.RetryWhen;
import com.dtflys.forest.callback.SuccessWhen;
import com.dtflys.forest.config.ForestProperties;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.auto.DefaultAutoConverter;
import com.dtflys.forest.converter.binary.DefaultBinaryConverter;
import com.dtflys.forest.converter.form.DefaultFormConvertor;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.converter.json.JSONConverterSelector;
import com.dtflys.forest.converter.protobuf.ForestProtobufConverter;
import com.dtflys.forest.converter.protobuf.ForestProtobufConverterManager;
import com.dtflys.forest.converter.text.DefaultTextConverter;
import com.dtflys.forest.converter.xml.ForestXmlConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.filter.EncodeFilter;
import com.dtflys.forest.filter.EncodeFormFilter;
import com.dtflys.forest.filter.EncodePathFilter;
import com.dtflys.forest.filter.EncodeQueryFilter;
import com.dtflys.forest.filter.EncodeUserInfoFilter;
import com.dtflys.forest.filter.Filter;
import com.dtflys.forest.filter.JSONFilter;
import com.dtflys.forest.filter.XmlFilter;
import com.dtflys.forest.http.ForestAddress;
import com.dtflys.forest.http.ForestAsyncMode;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRequestType;
import com.dtflys.forest.interceptor.DefaultInterceptorFactory;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.interceptor.InterceptorFactory;
import com.dtflys.forest.logging.DefaultLogHandler;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.pool.FixedRequestPool;
import com.dtflys.forest.pool.ForestRequestPool;
import com.dtflys.forest.proxy.ProxyFactory;
import com.dtflys.forest.reflection.BasicVariableValue;
import com.dtflys.forest.reflection.DefaultObjectFactory;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.reflection.ForestObjectFactory;
import com.dtflys.forest.reflection.ForestVariableValue;
import com.dtflys.forest.retryer.BackOffRetryer;
import com.dtflys.forest.ssl.SSLKeyStore;
import com.dtflys.forest.utils.ForestCache;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.TimeUtils;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForestConfiguration
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(ForestConfiguration.class);
    private static final Map<String, ForestConfiguration> CONFIGURATION_CACHE = new ConcurrentHashMap<String, ForestConfiguration>();
    private final Map<Class<?>, ProxyFactory<?>> CLIENT_PROXY_FACTORY_CACHE = new ConcurrentHashMap();
    private static final ForestConfiguration defaultConfiguration = ForestConfiguration.configuration();
    private Map<Class, Object> instanceCache = new ConcurrentHashMap<Class, Object>();
    private String id;
    private Integer maxConnections;
    private Integer maxRouteConnections;
    private Integer maxRequestQueueSize;
    private Integer maxAsyncThreadSize;
    private ForestAsyncMode asyncMode = ForestAsyncMode.PLATFORM;
    private Integer maxAsyncQueueSize;
    private boolean autoRedirection = true;
    private Integer timeout;
    private String charset = "UTF-8";
    private Integer connectTimeout;
    private Integer readTimeout;
    private Class retryer;
    private Integer maxRetryCount;
    private long maxRetryInterval;
    private ForestAddress baseAddress;
    private Class<? extends AddressSource> baseAddressSourceClass;
    private String sslProtocol;
    private boolean logEnabled = true;
    private boolean logRequest = true;
    private boolean logResponseStatus = true;
    private boolean logResponseContent = false;
    private ForestLogHandler logHandler;
    private boolean cacheEnabled = true;
    private volatile HttpBackend backend;
    private Integer backendClientCacheMaxSize;
    private Duration backendClientCacheExpireTime;
    private ForestCache<String, Object> backendClientCache;
    private String backendName;
    private List<RequestNameValue> defaultParameters;
    private List<RequestNameValue> defaultHeaders;
    private Class<? extends RejectedExecutionHandler> asyncRejectPolicyClass;
    private Class<? extends SuccessWhen> successWhenClass;
    private Class<? extends RetryWhen> retryWhenClass;
    private List<Class<? extends Interceptor>> interceptors;
    private Map<ForestDataType, ForestConverter> converterMap;
    private JSONConverterSelector jsonConverterSelector;
    private ForestObjectFactory forestObjectFactory;
    private InterceptorFactory interceptorFactory;
    private ForestProperties properties;
    private HttpBackendSelector httpBackendSelector = new HttpBackendSelector();
    private Map<String, Class> filterRegisterMap = new HashMap<String, Class>();
    private Map<String, ForestVariableValue> variables = new ConcurrentHashMap<String, ForestVariableValue>(64);
    private Map<String, SSLKeyStore> sslKeyStores = new HashMap<String, SSLKeyStore>();
    private ForestRequestPool pool;
    ThreadPoolExecutor asyncPool;
    final Object ASYNC_POOL_LOCK = new Object();

    private ForestConfiguration() {
    }

    public static ForestConfiguration getDefaultConfiguration() {
        return defaultConfiguration;
    }

    public static ForestConfiguration configuration() {
        return ForestConfiguration.configuration("forestConfiguration");
    }

    public static ForestConfiguration configuration(String id) {
        return CONFIGURATION_CACHE.computeIfAbsent(id, key -> ForestConfiguration.createConfiguration().setId((String)key));
    }

    public static ForestConfiguration createConfiguration() {
        ForestConfiguration configuration = new ForestConfiguration();
        configuration.setId("forestConfiguration" + configuration.hashCode());
        configuration.setJsonConverterSelector(new JSONConverterSelector());
        ForestProtobufConverterManager protobufConverterFactory = ForestProtobufConverterManager.getInstance();
        configuration.setProtobufConverter(protobufConverterFactory.getForestProtobufConverter());
        ServiceLoader.load(ForestXmlConverter.class).forEach(configuration::setXmlConverter);
        configuration.setTextConverter(new DefaultTextConverter());
        DefaultAutoConverter autoConverter = new DefaultAutoConverter(configuration);
        Map<ForestDataType, ForestConverter> converterMap = configuration.getConverterMap();
        converterMap.put(ForestDataType.AUTO, autoConverter);
        converterMap.put(ForestDataType.BINARY, new DefaultBinaryConverter(autoConverter));
        converterMap.put(ForestDataType.FORM, new DefaultFormConvertor(configuration));
        ForestConfiguration.setupJSONConverter(configuration);
        configuration.setBackendClientCacheMaxSize(128);
        configuration.setTimeout(3000);
        configuration.setMaxConnections(500);
        configuration.setMaxRouteConnections(500);
        configuration.setRetryer(BackOffRetryer.class);
        configuration.setMaxRetryCount(0);
        configuration.setMaxRetryInterval(0L);
        configuration.registerFilter("json", JSONFilter.class);
        configuration.registerFilter("xml", XmlFilter.class);
        configuration.registerFilter("encode", EncodeFilter.class);
        configuration.registerFilter("encodeUserInfo", EncodeUserInfoFilter.class);
        configuration.registerFilter("encodePath", EncodePathFilter.class);
        configuration.registerFilter("encodeQuery", EncodeQueryFilter.class);
        configuration.registerFilter("encodeForm", EncodeFormFilter.class);
        configuration.setLogHandler(new DefaultLogHandler());
        return configuration;
    }

    public List<ForestConfiguration> allConfigurations() {
        return CONFIGURATION_CACHE.values().stream().collect(Collectors.toList());
    }

    public Map<Class, Object> getInstanceCache() {
        return this.instanceCache;
    }

    private ForestConfiguration setupBackend() {
        this.setBackend(this.httpBackendSelector.select(this));
        return this;
    }

    public HttpBackendSelector getBackendSelector() {
        return this.httpBackendSelector;
    }

    public ForestConfiguration setBackend(HttpBackend backend) {
        if (backend != null) {
            backend.init(this);
            log.info("[Forest] Http Backend: " + backend.getName());
        }
        this.backend = backend;
        return this;
    }

    public ForestConfiguration setBackendName(String backendName) {
        this.backendName = backendName;
        return this;
    }

    public String getBackendName() {
        if (this.backend != null) {
            return this.backend.getName();
        }
        return this.backendName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpBackend getBackend() {
        if (this.backend == null) {
            ForestConfiguration forestConfiguration = this;
            synchronized (forestConfiguration) {
                if (this.backend == null) {
                    this.setupBackend();
                }
            }
        }
        return this.backend;
    }

    public Map<String, HttpBackend> getAllCreatedBackends() {
        return this.httpBackendSelector.getAllCreatedBackends();
    }

    public Integer getBackendClientCacheMaxSize() {
        return this.backendClientCacheMaxSize;
    }

    public ForestConfiguration setBackendClientCacheMaxSize(Integer backendClientCacheMaxSize) {
        this.backendClientCacheMaxSize = backendClientCacheMaxSize;
        return this;
    }

    public Duration getBackendClientCacheExpireTime() {
        return this.backendClientCacheExpireTime;
    }

    public ForestConfiguration setBackendClientCacheExpireTime(Duration backendClientCacheExpireTime) {
        this.backendClientCacheExpireTime = backendClientCacheExpireTime;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForestObjectFactory getForestObjectFactory() {
        if (this.forestObjectFactory == null) {
            ForestConfiguration forestConfiguration = this;
            synchronized (forestConfiguration) {
                if (this.forestObjectFactory == null) {
                    this.forestObjectFactory = new DefaultObjectFactory();
                }
            }
        }
        return this.forestObjectFactory;
    }

    public <T> T getForestObject(Class<T> clazz) {
        return this.getForestObjectFactory().getObject(clazz);
    }

    public ForestConfiguration setForestObjectFactory(ForestObjectFactory forestObjectFactory) {
        this.forestObjectFactory = forestObjectFactory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorFactory getInterceptorFactory() {
        if (this.interceptorFactory == null) {
            ForestConfiguration forestConfiguration = this;
            synchronized (forestConfiguration) {
                if (this.interceptorFactory == null) {
                    this.interceptorFactory = new DefaultInterceptorFactory();
                }
            }
        }
        return this.interceptorFactory;
    }

    public ForestConfiguration setInterceptorFactory(InterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForestProperties getProperties() {
        if (this.properties == null) {
            ForestConfiguration forestConfiguration = this;
            synchronized (forestConfiguration) {
                if (this.properties == null) {
                    this.properties = new ForestProperties();
                }
            }
        }
        return this.properties;
    }

    public ForestConfiguration setProperties(ForestProperties properties) {
        this.properties = properties;
        return this;
    }

    public ForestConfiguration setHttpBackendSelector(HttpBackendSelector httpBackendSelector) {
        this.httpBackendSelector = httpBackendSelector;
        return this;
    }

    private static void setupJSONConverter(ForestConfiguration configuration) {
        configuration.setJsonConverter(configuration.jsonConverterSelector.select());
    }

    public String getId() {
        return this.id;
    }

    private ForestConfiguration setId(String id) {
        this.id = id;
        return this;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public ForestConfiguration setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public Integer getMaxRouteConnections() {
        return this.maxRouteConnections;
    }

    public ForestConfiguration setMaxRouteConnections(Integer maxRouteConnections) {
        this.maxRouteConnections = maxRouteConnections;
        return this;
    }

    public Integer getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public ForestConfiguration setMaxRequestQueueSize(Integer maxRequestQueueSize) {
        this.maxRequestQueueSize = maxRequestQueueSize;
        return this;
    }

    public Integer getMaxAsyncThreadSize() {
        return this.maxAsyncThreadSize;
    }

    public ForestConfiguration setMaxAsyncThreadSize(Integer maxAsyncThreadSize) {
        this.maxAsyncThreadSize = maxAsyncThreadSize;
        return this;
    }

    public ForestAsyncMode getAsyncMode() {
        return this.asyncMode;
    }

    public ForestConfiguration setAsyncMode(ForestAsyncMode asyncMode) {
        this.asyncMode = asyncMode;
        return this;
    }

    public Integer getMaxAsyncQueueSize() {
        return this.maxAsyncQueueSize;
    }

    public ForestConfiguration setMaxAsyncQueueSize(Integer maxAsyncQueueSize) {
        this.maxAsyncQueueSize = maxAsyncQueueSize;
        return this;
    }

    public boolean isAutoRedirection() {
        return this.autoRedirection;
    }

    public ForestConfiguration setAutoRedirection(boolean autoRedirection) {
        this.autoRedirection = autoRedirection;
        return this;
    }

    @Deprecated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public ForestConfiguration setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public ForestConfiguration setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public ForestConfiguration setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ForestConfiguration setConnectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = TimeUtils.toMillis("global connect timeout", connectTimeout, timeUnit);
        return this;
    }

    public ForestConfiguration setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = TimeUtils.toMillis("global connect timeout", connectTimeout);
        return this;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public ForestConfiguration setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public ForestConfiguration setReadTimeout(int readTimeout, TimeUnit timeUnit) {
        this.readTimeout = TimeUtils.toMillis("global read timeout", readTimeout, timeUnit);
        return this;
    }

    public ForestConfiguration setReadTimeout(Duration readTimeout) {
        this.readTimeout = TimeUtils.toMillis("global read timeout", readTimeout);
        return this;
    }

    public Class getRetryer() {
        return this.retryer;
    }

    public ForestConfiguration setRetryer(Class retryer) {
        this.retryer = retryer;
        return this;
    }

    @Deprecated
    public Integer getRetryCount() {
        return this.maxRetryCount;
    }

    @Deprecated
    public ForestConfiguration setRetryCount(Integer retryCount) {
        this.maxRetryCount = retryCount;
        return this;
    }

    public Integer getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public ForestConfiguration setMaxRetryCount(Integer maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public ForestConfiguration setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public ForestAddress getBaseAddress() {
        return this.baseAddress;
    }

    public ForestConfiguration setBaseAddress(ForestAddress baseAddress) {
        this.baseAddress = baseAddress;
        return this;
    }

    public ForestConfiguration setBaseAddressScheme(String scheme) {
        this.baseAddress = this.baseAddress == null ? new ForestAddress(scheme, null, null) : new ForestAddress(scheme, this.baseAddress.getHost(), this.baseAddress.getPort());
        return this;
    }

    public ForestConfiguration setBaseAddressHost(String host) {
        this.baseAddress = this.baseAddress == null ? new ForestAddress(host, null) : new ForestAddress(this.baseAddress.getScheme(), host, this.baseAddress.getPort());
        return this;
    }

    public ForestConfiguration setBaseAddressPort(Integer port) {
        if (port == null) {
            return this;
        }
        this.baseAddress = this.baseAddress == null ? new ForestAddress(null, port) : new ForestAddress(this.baseAddress.getScheme(), this.baseAddress.getHost(), port);
        return this;
    }

    public AddressSource getBaseAddressSource() {
        if (this.baseAddressSourceClass == null) {
            return null;
        }
        return this.getForestObjectFactory().getObject(this.baseAddressSourceClass);
    }

    public ForestConfiguration setBaseAddressSourceClass(Class<? extends AddressSource> baseAddressSourceClass) {
        this.baseAddressSourceClass = baseAddressSourceClass;
        return this;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public ForestConfiguration setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public ForestConfiguration setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public boolean isLogRequest() {
        return this.logRequest;
    }

    public ForestConfiguration setLogRequest(boolean logRequest) {
        this.logRequest = logRequest;
        return this;
    }

    public boolean isLogResponseStatus() {
        return this.logResponseStatus;
    }

    public ForestConfiguration setLogResponseStatus(boolean logResponseStatus) {
        this.logResponseStatus = logResponseStatus;
        return this;
    }

    public boolean isLogResponseContent() {
        return this.logResponseContent;
    }

    public ForestConfiguration setLogResponseContent(boolean logResponseContent) {
        this.logResponseContent = logResponseContent;
        return this;
    }

    public ForestLogHandler getLogHandler() {
        return this.logHandler;
    }

    public ForestConfiguration setLogHandler(ForestLogHandler logHandler) {
        this.logHandler = logHandler;
        return this;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public ForestConfiguration setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        return this;
    }

    public List<RequestNameValue> getDefaultParameters() {
        return this.defaultParameters;
    }

    public ForestConfiguration setDefaultParameters(List<RequestNameValue> defaultParameters) {
        this.defaultParameters = defaultParameters;
        return this;
    }

    public List<RequestNameValue> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public ForestConfiguration setDefaultHeaders(List<RequestNameValue> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public RejectedExecutionHandler getAsyncRejectPolicy() {
        if (this.asyncRejectPolicyClass == null) {
            return this.getForestObjectFactory().getObject(RejectedExecutionHandler.class);
        }
        return this.getForestObjectFactory().getObject(this.asyncRejectPolicyClass);
    }

    public Class<? extends RejectedExecutionHandler> getAsyncRejectPolicyClass() {
        return this.asyncRejectPolicyClass;
    }

    public ForestConfiguration setAsyncRejectPolicyClass(Class<? extends RejectedExecutionHandler> asyncRejectPolicyClass) {
        this.asyncRejectPolicyClass = asyncRejectPolicyClass;
        return this;
    }

    public RetryWhen getRetryWhen() {
        if (this.retryWhenClass == null) {
            return null;
        }
        return this.getForestObjectFactory().getObject(this.retryWhenClass);
    }

    public ForestConfiguration setRetryWhenClass(Class<? extends RetryWhen> retryWhenClass) {
        this.retryWhenClass = retryWhenClass;
        return this;
    }

    public SuccessWhen getSuccessWhen() {
        if (this.successWhenClass == null) {
            return null;
        }
        return this.getForestObjectFactory().getObject(this.successWhenClass);
    }

    public ForestConfiguration setSuccessWhenClass(Class<? extends SuccessWhen> successWhenClass) {
        this.successWhenClass = successWhenClass;
        return this;
    }

    public List<Class<? extends Interceptor>> getInterceptors() {
        return this.interceptors;
    }

    public ForestConfiguration setInterceptors(List<Class<? extends Interceptor>> interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public ForestConfiguration setJsonConverter(ForestJsonConverter converter) {
        this.getConverterMap().put(ForestDataType.JSON, converter);
        return this;
    }

    public ForestJsonConverter getJsonConverter() {
        ForestJsonConverter jsonConverter = (ForestJsonConverter)this.getConverterMap().get(ForestDataType.JSON);
        if (jsonConverter == null) {
            throw new ForestRuntimeException("JSON converter cannot be found. Please check your classpath if there is the JSON framework, eg. Jackson (>= 2.9.10), Gson or Fastjson (>= 1.2.48), in the dependencies of your project.");
        }
        return jsonConverter;
    }

    public ForestConfiguration setXmlConverter(ForestXmlConverter converter) {
        this.getConverterMap().put(ForestDataType.XML, converter);
        return this;
    }

    public ForestXmlConverter getXmlConverter() {
        return (ForestXmlConverter)this.getConverterMap().get(ForestDataType.XML);
    }

    public ForestConfiguration setProtobufConverter(ForestProtobufConverter converter) {
        this.getConverterMap().put(ForestDataType.PROTOBUF, converter);
        return this;
    }

    public ForestProtobufConverter getProtobufConverter() {
        ForestProtobufConverter converter = (ForestProtobufConverter)this.getConverterMap().get(ForestDataType.PROTOBUF);
        if (converter == null) {
            throw new ForestRuntimeException("Protobuf converter cannot be found. Please check your classpath if there is the Protobuf framework in the dependencies of your project.");
        }
        return converter;
    }

    private ForestConfiguration setTextConverter(ForestConverter converter) {
        this.getConverterMap().put(ForestDataType.TEXT, converter);
        return this;
    }

    private ForestConverter getTextConverter() {
        return this.getConverterMap().get(ForestDataType.TEXT);
    }

    public <T> ProxyFactory<T> getProxyFactory(Class<T> clazz) {
        return this.CLIENT_PROXY_FACTORY_CACHE.computeIfAbsent(clazz, cls -> new ProxyFactory(this, cls));
    }

    public ForestConfiguration setVariableValue(String name, Object value) {
        this.variables.put(name, new BasicVariableValue(value));
        return this;
    }

    public ForestConfiguration setVariableValue(String name, ForestVariableValue value) {
        this.variables.put(name, value);
        return this;
    }

    public Object getVariableValue(String name) {
        return this.getVariableValue(name, null);
    }

    public Object getVariableValue(String name, ForestMethod method) {
        ForestVariableValue variableValue = this.variables.get(name);
        if (variableValue != null) {
            Object value = variableValue.getValue(method);
            return value;
        }
        return null;
    }

    public boolean isVariableDefined(String name) {
        return this.getVariables().containsKey(name);
    }

    public Map<String, SSLKeyStore> getSslKeyStores() {
        return this.sslKeyStores;
    }

    public ForestConfiguration setSslKeyStores(Map<String, SSLKeyStore> sslKeyStores) {
        this.sslKeyStores = sslKeyStores;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForestRequestPool getPool() {
        if (this.pool == null) {
            ForestConfiguration forestConfiguration = this;
            synchronized (forestConfiguration) {
                if (this.pool == null) {
                    this.pool = new FixedRequestPool(this);
                }
            }
        }
        return this.pool;
    }

    public void setPool(ForestRequestPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForestCache<String, Object> getBackendClientCache() {
        if (this.backendClientCache == null) {
            ForestConfiguration forestConfiguration = this;
            synchronized (forestConfiguration) {
                if (this.backendClientCache == null) {
                    Duration expireTime = this.getBackendClientCacheExpireTime();
                    this.backendClientCache = expireTime != null ? new ForestCache(this.getBackendClientCacheMaxSize().intValue(), expireTime.getNano(), TimeUnit.NANOSECONDS) : new ForestCache(this.getBackendClientCacheMaxSize().intValue(), 6L, TimeUnit.HOURS);
                }
            }
        }
        return this.backendClientCache;
    }

    public <T> T getBackendClient(String key) {
        Object client = this.getBackendClientCache().get(key);
        if (client != null) {
            return (T)client;
        }
        return null;
    }

    public void putBackendClientToCache(String key, Object client) {
        this.getBackendClientCache().put(key, client);
    }

    public ForestConfiguration registerKeyStore(SSLKeyStore keyStore) {
        this.sslKeyStores.put(keyStore.getId(), keyStore);
        return this;
    }

    public SSLKeyStore getKeyStore(String id) {
        return this.sslKeyStores.get(id);
    }

    public ForestConverter getConverter(ForestDataType dataType) {
        ForestConverter converter = this.getConverterMap().get(dataType);
        if (converter == null) {
            throw new ForestRuntimeException("Can not found converter for type " + dataType.getName());
        }
        return converter;
    }

    public Map<ForestDataType, ForestConverter> getConverterMap() {
        if (this.converterMap == null) {
            this.converterMap = new HashMap<ForestDataType, ForestConverter>();
        }
        return this.converterMap;
    }

    public ForestConfiguration setConverterMap(Map<ForestDataType, ForestConverter> converterMap) {
        this.converterMap = converterMap;
        return this;
    }

    public ForestConfiguration setToMergeConverterMap(Map<ForestDataType, ForestConverter> converterMap) {
        if (converterMap == null) {
            return this;
        }
        for (Map.Entry<ForestDataType, ForestConverter> entry : converterMap.entrySet()) {
            ForestDataType dataType = entry.getKey();
            ForestConverter converter = entry.getValue();
            this.converterMap.put(dataType, converter);
        }
        return this;
    }

    public Map<String, ForestVariableValue> getVariables() {
        return this.variables;
    }

    public ForestConfiguration addAllVariables(Map<String, Object> variables) {
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.setVariableValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ForestConfiguration setVariables(Map<String, Object> variables) {
        this.variables.clear();
        this.addAllVariables(variables);
        return this;
    }

    public <T> T createInstance(Class<T> clazz) {
        ProxyFactory<T> proxyFactory = this.getProxyFactory(clazz);
        return proxyFactory.createInstance();
    }

    public <T> T client(Class<T> clazz) {
        return this.createInstance(clazz);
    }

    private ForestConfiguration setJsonConverterSelector(JSONConverterSelector jsonConverterSelector) {
        this.jsonConverterSelector = jsonConverterSelector;
        return this;
    }

    public ForestConfiguration registerFilter(String name, Class filterClass) {
        if (!Filter.class.isAssignableFrom(filterClass)) {
            throw new ForestRuntimeException("Cannot register class \"" + filterClass.getName() + "\" as a filter, filter class must implement Filter interface!");
        }
        this.filterRegisterMap.put(name, filterClass);
        return this;
    }

    public List<String> getRegisteredFilterNames() {
        Set<String> nameSet = this.filterRegisterMap.keySet();
        ArrayList<String> names = new ArrayList<String>();
        Iterator<String> iterator = nameSet.iterator();
        while (iterator.hasNext()) {
            names.add(iterator.next());
        }
        return names;
    }

    public boolean hasFilter(String name) {
        return this.filterRegisterMap.containsKey(name);
    }

    public Filter newFilterInstance(String name) {
        Class filterClass = this.filterRegisterMap.get(name);
        if (filterClass == null) {
            throw new ForestRuntimeException("filter \"" + name + "\" does not exists!");
        }
        try {
            return (Filter)filterClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ForestRuntimeException("An error occurred the initialization of filter \"" + name + "\" ! cause: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException("An error occurred the initialization of filter \"" + name + "\" ! cause: " + e.getMessage(), e);
        }
    }

    public ForestRequest<?> request() {
        ForestGenericClient client = this.client(ForestGenericClient.class);
        return client.request();
    }

    public <R> ForestRequest<R> request(Class<R> clazz) {
        ForestGenericClient client = this.client(ForestGenericClient.class);
        return client.request(clazz);
    }

    public ForestRequest<?> get(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.GET).setUrl(url);
    }

    public ForestRequest<?> post(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.POST).setUrl(url);
    }

    public ForestRequest<?> put(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.PUT).setUrl(url);
    }

    public ForestRequest<?> delete(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.DELETE).setUrl(url);
    }

    public ForestRequest<?> head(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.HEAD).setUrl(url);
    }

    public ForestRequest<?> patch(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.PATCH).setUrl(url);
    }

    public ForestRequest<?> options(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.OPTIONS).setUrl(url);
    }

    public ForestRequest<?> trace(String url) {
        return this.request().setType(null).clearTypeChangeHistory().setType(ForestRequestType.TRACE).setUrl(url);
    }
}

