/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter;

import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.Lazy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ConvertOptions {
    private NullValuePolicy nullValuePolicy;
    private Set<String> excludedFieldNames = new HashSet<String>();
    private boolean evaluateLazyValue = true;

    public static ConvertOptions defaultOptions() {
        return new ConvertOptions().nullValuePolicy(NullValuePolicy.IGNORE);
    }

    public ConvertOptions exclude(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.excludedFieldNames.add(fieldName);
        }
        return this;
    }

    public ConvertOptions exclude(Collection<String> fieldNames) {
        this.excludedFieldNames.addAll(fieldNames);
        return this;
    }

    public boolean isEvaluateLazyValue() {
        return this.evaluateLazyValue;
    }

    public ConvertOptions evaluateLazyValue(boolean evaluateLazyValue) {
        this.evaluateLazyValue = evaluateLazyValue;
        return this;
    }

    public Set<String> excludedFieldNames() {
        return this.excludedFieldNames;
    }

    public ConvertOptions nullValuePolicy(NullValuePolicy nullValuePolicy) {
        this.nullValuePolicy = nullValuePolicy;
        return this;
    }

    public NullValuePolicy nullValuePolicy() {
        return this.nullValuePolicy;
    }

    public boolean shouldExclude(String fieldName) {
        return this.excludedFieldNames.contains(fieldName);
    }

    public boolean shouldIgnore(Object value) {
        return value == null && NullValuePolicy.IGNORE.equals((Object)this.nullValuePolicy);
    }

    public Object getValue(Object value, ForestRequest request) {
        if (value != null) {
            if (request != null && value instanceof Lazy) {
                Object result = null;
                if (!this.evaluateLazyValue) {
                    return value;
                }
                result = ((Lazy)value).eval(request);
                if (result != null) {
                    return result;
                }
            } else {
                return value;
            }
        }
        return NullValuePolicy.WRITE_NULL_STRING.equals((Object)this.nullValuePolicy) ? "null" : (NullValuePolicy.WRITE_EMPTY_STRING.equals((Object)this.nullValuePolicy) ? "" : null);
    }

    public static enum NullValuePolicy {
        IGNORE,
        WRITE_NULL_STRING,
        WRITE_EMPTY_STRING;

    }
}

