/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.dtflys.forest.converter.ConvertOptions;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.Lazy;
import com.dtflys.forest.utils.ForestDataType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ForestFastjson2Converter
implements ForestJsonConverter {
    private static final Set<Charset> SUPPORTED_CHARSETS = new HashSet<Charset>();
    private final List<JSONWriter.Feature> writerFeatures = new LinkedList<JSONWriter.Feature>();
    private final List<JSONReader.Feature> readFeatures = new LinkedList<JSONReader.Feature>();
    private String dateFormat;

    public List<JSONWriter.Feature> getWriterFeatures() {
        return this.writerFeatures;
    }

    public List<JSONReader.Feature> getReadFeatures() {
        return this.readFeatures;
    }

    public void addWriterFeature(JSONWriter.Feature feature) {
        this.writerFeatures.add(feature);
    }

    public void addReadFeature(JSONReader.Feature feature) {
        this.readFeatures.add(feature);
    }

    private JSONReader.Feature[] getReadFeatureArray() {
        return this.readFeatures.toArray(new JSONReader.Feature[0]);
    }

    private JSONWriter.Feature[] getWriterFeatureArray() {
        return this.writerFeatures.toArray(new JSONWriter.Feature[0]);
    }

    @Override
    public <T> T convertToJavaObject(String source, Type targetType) {
        try {
            return (T)JSON.parseObject((String)source, (Type)targetType, (JSONReader.Feature[])this.getReadFeatureArray());
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        try {
            return (T)JSON.parseObject((byte[])source, (int)0, (int)source.length, (Charset)(charset != null ? charset : StandardCharsets.UTF_8), targetType, (JSONReader.Feature[])this.readFeatures.toArray(new JSONReader.Feature[0]));
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        try {
            Charset cs = SUPPORTED_CHARSETS.contains(charset) ? charset : StandardCharsets.UTF_8;
            return (T)JSON.parseObject((byte[])source, (int)0, (int)source.length, (Charset)cs, (Type)targetType);
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    @Override
    public <T> T convertToJavaObject(String source, TypeReference<T> typeReference) {
        try {
            return (T)JSON.parseObject((String)source, typeReference, (JSONReader.Feature[])new JSONReader.Feature[0]);
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    private String parseToString(Object obj) {
        return JSON.toJSONString((Object)obj, (String)this.dateFormat, (JSONWriter.Feature[])this.getWriterFeatureArray());
    }

    @Override
    public String encodeToString(Object obj) {
        if (obj instanceof CharSequence) {
            obj.toString();
        }
        try {
            return this.parseToString(obj);
        }
        catch (Throwable th) {
            throw new ForestRuntimeException(th);
        }
    }

    @Override
    public Map<String, Object> convertObjectToMap(Object obj, ForestRequest request, ConvertOptions options) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>(objMap.size());
            for (Object key : objMap.keySet()) {
                Object val;
                String name = String.valueOf(key);
                if (options != null && options.shouldExclude(name) || Lazy.isEvaluatingLazyValue(val = objMap.get(key), request)) continue;
                if (options != null) {
                    Object evalValue = options.getValue(val, request);
                    if (options.shouldIgnore(evalValue)) continue;
                    newMap.put(name, evalValue);
                    continue;
                }
                newMap.put(name, val);
            }
            return newMap;
        }
        if (obj instanceof CharSequence) {
            return this.convertToJavaObject(obj.toString(), LinkedHashMap.class);
        }
        JSONObject jsonObject = (JSONObject)Optional.ofNullable(JSON.toJSON((Object)obj)).orElse(new JSONObject());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (!jsonObject.isEmpty()) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (Lazy.isEvaluatingLazyValue(value, request)) continue;
                if (options != null) {
                    Object evalValue = options.getValue(value, request);
                    if (options.shouldIgnore(evalValue)) continue;
                    map.put(name, evalValue);
                    continue;
                }
                map.put(name, value);
            }
        }
        return map;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.JSON;
    }

    static {
        SUPPORTED_CHARSETS.add(StandardCharsets.UTF_8);
        SUPPORTED_CHARSETS.add(StandardCharsets.UTF_16);
        SUPPORTED_CHARSETS.add(StandardCharsets.UTF_16BE);
        SUPPORTED_CHARSETS.add(StandardCharsets.UTF_16LE);
        SUPPORTED_CHARSETS.add(StandardCharsets.US_ASCII);
        SUPPORTED_CHARSETS.add(StandardCharsets.ISO_8859_1);
    }
}

