/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import com.dtflys.forest.converter.ConvertOptions;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.Lazy;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ForestFastjsonConverter
implements ForestJsonConverter {
    private String serializerFeatureName = "DisableCircularReferenceDetect";
    private SerializerFeature serializerFeature;
    private String dateFormat;
    private static Field nameField;
    private static Method nameMethod;

    public String getSerializerFeatureName() {
        return this.serializerFeatureName;
    }

    public void setSerializerFeatureName(String serializerFeatureName) {
        if (StringUtils.isNotBlank(serializerFeatureName)) {
            this.serializerFeatureName = serializerFeatureName;
            SerializerFeature feature = SerializerFeature.valueOf((String)serializerFeatureName);
            this.setSerializerFeature(feature);
        }
    }

    public SerializerFeature getSerializerFeature() {
        return this.serializerFeature;
    }

    public ForestFastjsonConverter() {
        this.setSerializerFeature(SerializerFeature.valueOf((String)this.serializerFeatureName));
    }

    public void setSerializerFeature(SerializerFeature serializerFeature) {
        this.serializerFeature = serializerFeature;
        this.serializerFeatureName = serializerFeature == null ? null : serializerFeature.name();
    }

    @Override
    public <T> T convertToJavaObject(String source, Type targetType) {
        try {
            return (T)JSON.parseObject((String)source, (Type)targetType, (Feature[])new Feature[0]);
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        try {
            return (T)JSON.parseObject((byte[])source, (int)0, (int)source.length, (Charset)(charset != null ? charset : StandardCharsets.UTF_8), targetType, (Feature[])new Feature[0]);
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        try {
            return (T)JSON.parseObject((byte[])source, (int)0, (int)source.length, (Charset)charset, (Type)targetType, (Feature[])new Feature[0]);
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    @Override
    public <T> T convertToJavaObject(String source, TypeReference<T> typeReference) {
        try {
            return (T)JSON.parseObject((String)source, typeReference, (Feature[])new Feature[0]);
        }
        catch (Throwable th) {
            throw new ForestConvertException(this, th);
        }
    }

    private String parseToString(Object obj) {
        if (this.serializerFeature == null) {
            return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        }
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, this.serializerFeature});
    }

    @Override
    public String encodeToString(Object obj) {
        if (obj instanceof CharSequence) {
            obj.toString();
        }
        try {
            return this.parseToString(obj);
        }
        catch (Throwable th) {
            throw new ForestRuntimeException(th);
        }
    }

    private static Object toJSON(Object javaObject, ForestRequest request, ConvertOptions options) {
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        return ForestFastjsonConverter.toJSON(javaObject, parserConfig, request, options);
    }

    private static Object toJSON(Object javaObject, ParserConfig mapping, ForestRequest request, ConvertOptions options) {
        if (javaObject == null) {
            return null;
        }
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            JSONObject json = new JSONObject(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                String jsonKey = TypeUtils.castToString(key);
                if (options != null && options.shouldExclude(jsonKey)) continue;
                Object jsonValue = ForestFastjsonConverter.toJSON(entry.getValue(), request, options);
                if (options != null && options.shouldIgnore(jsonValue)) continue;
                json.put(jsonKey, jsonValue);
            }
            return json;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            JSONArray array = new JSONArray(collection.size());
            for (Object item : collection) {
                Object jsonValue = ForestFastjsonConverter.toJSON(item, request, options);
                array.add(jsonValue);
            }
            return array;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isEnum()) {
            return ((Enum)javaObject).name();
        }
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            JSONArray array = new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                Object jsonValue = ForestFastjsonConverter.toJSON(item, request, options);
                array.add(jsonValue);
            }
            return array;
        }
        if (mapping.isPrimitive(clazz)) {
            return javaObject;
        }
        try {
            List getters = TypeUtils.computeGetters(clazz, null);
            JSONObject json = new JSONObject(getters.size(), true);
            for (FieldInfo field : getters) {
                Object value;
                if (options != null && options.shouldExclude(field.name) || Lazy.isEvaluatingLazyValue(value = field.get(javaObject), request) || options != null && options.shouldIgnore(value = options.getValue(value, request))) continue;
                Object jsonValue = JSON.toJSON((Object)value);
                if (nameField != null) {
                    json.put((String)nameField.get(field), jsonValue);
                    continue;
                }
                if (nameMethod == null) continue;
                json.put((String)nameMethod.invoke((Object)field, new Object[0]), jsonValue);
            }
            return json;
        }
        catch (IllegalAccessException e) {
            throw new JSONException("toJSON error", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JSONException("toJSON error", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> convertObjectToMap(Object obj, ForestRequest request, ConvertOptions options) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>(objMap.size());
            for (Object key : objMap.keySet()) {
                Object val;
                String name = String.valueOf(key);
                if (options != null && options.shouldExclude(name) || Lazy.isEvaluatingLazyValue(val = objMap.get(key), request) || options != null && options.shouldIgnore(val = options.getValue(val, request)) || val == null) continue;
                newMap.put(name, val);
            }
            return newMap;
        }
        if (nameField == null && nameMethod == null) {
            return this.defaultJsonMap(obj, options);
        }
        if (obj instanceof CharSequence) {
            return this.convertToJavaObject(obj.toString(), LinkedHashMap.class);
        }
        List getters = TypeUtils.computeGetters(obj.getClass(), null);
        JSONObject json = new JSONObject(getters.size(), true);
        try {
            for (FieldInfo field : getters) {
                Object value;
                if (options != null && options.shouldExclude(field.name) || Lazy.isEvaluatingLazyValue(value = field.get(obj), request) || options != null && options.shouldIgnore(value = options.getValue(value, request))) continue;
                if (nameField != null) {
                    json.put((String)nameField.get(field), value);
                    continue;
                }
                if (nameMethod == null) continue;
                json.put((String)nameMethod.invoke((Object)field, new Object[0]), value);
            }
            return json;
        }
        catch (IllegalAccessException e) {
            return this.defaultJsonMap(obj, options);
        }
        catch (InvocationTargetException e) {
            return this.defaultJsonMap(obj, options);
        }
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
        if (StringUtils.isNotBlank(format)) {
            JSON.DEFFAULT_DATE_FORMAT = format;
        }
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    public Map<String, Object> defaultJsonMap(Object obj, ConvertOptions options) {
        Object jsonObj = JSON.toJSON((Object)obj);
        Map map = (Map)jsonObj;
        if (map != null && options != null) {
            for (Map.Entry entity : map.entrySet()) {
                String name = (String)entity.getKey();
                if (!options.shouldExclude(name)) continue;
                map.remove(name);
            }
        }
        return map;
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.JSON;
    }

    static {
        Class<FieldInfo> clazz = FieldInfo.class;
        try {
            nameField = clazz.getField("name");
        }
        catch (NoSuchFieldException e) {
            try {
                nameMethod = clazz.getMethod("getName", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

