/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.dtflys.forest.converter.ConvertOptions;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.Lazy;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ForestGsonConverter
implements ForestJsonConverter {
    private String dateFormat;
    protected boolean isChangeGsonProper = false;
    private Gson singleGson;

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.isChangeGsonProper = true;
        this.dateFormat = dateFormat;
    }

    @Override
    public <T> T convertToJavaObject(String source, Type targetType) {
        if (StringUtils.isBlank(source)) {
            return null;
        }
        try {
            if (targetType instanceof ParameterizedType || targetType.getClass().getName().startsWith("com.google.gson")) {
                Gson gson = this.getGson();
                return (T)gson.fromJson(source, targetType);
            }
            Class<?> clazz = ReflectUtils.toClass(targetType);
            try {
                if (Map.class.isAssignableFrom(clazz)) {
                    JsonParser jsonParser = new JsonParser();
                    JsonObject jsonObject = jsonParser.parse(source).getAsJsonObject();
                    return (T)ForestGsonConverter.toMap(jsonObject, false);
                }
                if (List.class.isAssignableFrom(clazz)) {
                    JsonParser jsonParser = new JsonParser();
                    JsonArray jsonArray = jsonParser.parse(source).getAsJsonArray();
                    return (T)ForestGsonConverter.toList(jsonArray);
                }
                Gson gson = this.getGson();
                return (T)gson.fromJson(source, targetType);
            }
            catch (Throwable th) {
                throw new ForestConvertException(this, th);
            }
        }
        catch (Exception ex) {
            throw new ForestConvertException(this, (Throwable)ex);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        String str = StringUtils.fromBytes(source, charset);
        return this.convertToJavaObject(str, targetType);
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        String str = StringUtils.fromBytes(source, charset);
        return this.convertToJavaObject(str, targetType);
    }

    private static Map<String, Object> toMap(JsonObject json, boolean singleLevel) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set entrySet = json.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (singleLevel) {
                if (value instanceof JsonArray) {
                    map.put(key, ForestGsonConverter.toList((JsonArray)value));
                    continue;
                }
                if (value instanceof JsonPrimitive) {
                    map.put(key, ForestGsonConverter.toObject((JsonPrimitive)value));
                    continue;
                }
                map.put(key, value);
                continue;
            }
            if (value instanceof JsonArray) {
                map.put(key, ForestGsonConverter.toList((JsonArray)value));
                continue;
            }
            if (value instanceof JsonObject) {
                map.put(key, ForestGsonConverter.toMap((JsonObject)value, singleLevel));
                continue;
            }
            if (value instanceof JsonPrimitive) {
                map.put(key, ForestGsonConverter.toObject((JsonPrimitive)value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private static Object toObject(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        if (jsonPrimitive.isString()) {
            return jsonPrimitive.getAsString();
        }
        if (jsonPrimitive.isNumber()) {
            BigDecimal num = jsonPrimitive.getAsBigDecimal();
            int index = num.toString().indexOf(46);
            if (index == -1) {
                if (num.compareTo(new BigDecimal(Long.MAX_VALUE)) == 1) {
                    return num;
                }
                if (num.compareTo(new BigDecimal(Long.MIN_VALUE)) == -1) {
                    return num;
                }
                if (num.compareTo(new BigDecimal(Integer.MAX_VALUE)) == 1 || num.compareTo(new BigDecimal(Integer.MIN_VALUE)) == -1) {
                    return jsonPrimitive.getAsLong();
                }
                return jsonPrimitive.getAsInt();
            }
            double dvalue = jsonPrimitive.getAsDouble();
            float fvalue = jsonPrimitive.getAsFloat();
            if (String.valueOf(dvalue).equals(Float.valueOf(fvalue))) {
                return Float.valueOf(fvalue);
            }
            return dvalue;
        }
        if (jsonPrimitive.isJsonArray()) {
            return ForestGsonConverter.toList(jsonPrimitive.getAsJsonArray());
        }
        if (jsonPrimitive.isJsonObject()) {
            return ForestGsonConverter.toMap(jsonPrimitive.getAsJsonObject(), false);
        }
        return null;
    }

    private static List<Object> toList(JsonArray json) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < json.size(); ++i) {
            JsonElement value = json.get(i);
            if (value instanceof JsonArray) {
                list.add(ForestGsonConverter.toList((JsonArray)value));
                continue;
            }
            if (value instanceof JsonObject) {
                list.add(ForestGsonConverter.toMap((JsonObject)value, false));
                continue;
            }
            if (value instanceof JsonPrimitive) {
                list.add(ForestGsonConverter.toObject((JsonPrimitive)value));
                continue;
            }
            list.add(value);
        }
        return list;
    }

    protected Gson getGson() {
        if (this.isChangeGsonProper || this.singleGson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            if (StringUtils.isNotBlank(this.dateFormat)) {
                gsonBuilder.setDateFormat(this.dateFormat);
            }
            this.singleGson = gsonBuilder.create();
            this.isChangeGsonProper = false;
            return this.singleGson;
        }
        return this.singleGson;
    }

    @Override
    public String encodeToString(Object obj) {
        Gson gson = this.getGson();
        return gson.toJson(obj);
    }

    @Override
    public Map<String, Object> convertObjectToMap(Object obj, ForestRequest request, ConvertOptions options) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            HashMap<String, Object> newMap = new HashMap<String, Object>(objMap.size());
            for (Object key : objMap.keySet()) {
                Object val;
                String name = String.valueOf(key);
                if (options != null && options.shouldExclude(name) || Lazy.isEvaluatingLazyValue(val = objMap.get(key), request) || options != null && options.shouldIgnore(val = options.getValue(val, request)) || val == null) continue;
                newMap.put(name, val);
            }
            return newMap;
        }
        if (obj instanceof CharSequence) {
            return this.convertToJavaObject(obj.toString(), LinkedHashMap.class);
        }
        Gson gson = this.getGson();
        JsonElement jsonElement = gson.toJsonTree(obj);
        return ForestGsonConverter.toMap(jsonElement.getAsJsonObject(), true);
    }

    public String convertToJson(Object obj, Type type) {
        Gson gson = this.getGson();
        return gson.toJson(obj, type);
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.JSON;
    }
}

