/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.dtflys.forest.converter.ConvertOptions;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.Lazy;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.NameUtils;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;

public class ForestJacksonConverter
implements ForestJsonConverter {
    private String dateFormat;
    protected ObjectMapper mapper;
    private final ThreadLocal<ForestRequest> requestThreadLocal = new InheritableThreadLocal<ForestRequest>();
    private final ThreadLocal<ConvertOptions> optionsThreadLocal = new InheritableThreadLocal<ConvertOptions>();

    public ForestJacksonConverter(ObjectMapper mapper) {
        this.mapper = mapper.copy();
    }

    public ForestJacksonConverter() {
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Lazy.class, (JsonSerializer)new LazySerializer());
        this.mapper.registerModule((Module)module);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        if (StringUtils.isNotBlank(dateFormat)) {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            this.getMapper().setDateFormat((DateFormat)format);
        }
    }

    @Override
    public <T> T convertToJavaObject(String source, Type targetType) {
        try {
            return (T)this.getMapper().readValue(source, this.getMapper().getTypeFactory().constructType(targetType));
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        try {
            String str = StringUtils.fromBytes(source, charset);
            return (T)this.getMapper().readValue(str, this.getMapper().getTypeFactory().constructType(targetType));
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        try {
            String str = StringUtils.fromBytes(source, charset);
            return (T)this.getMapper().readValue(str, this.getMapper().getTypeFactory().constructType(targetType));
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    public <T> T convertToJavaObject(String source, Class<?> parametrized, Class<?> ... parameterClasses) {
        try {
            JavaType javaType = this.getMapper().getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)this.getMapper().readValue(source, javaType);
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    public <T> T convertToJavaObject(String source, JavaType javaType) {
        if (StringUtils.isBlank(source)) {
            return null;
        }
        try {
            return (T)this.getMapper().readValue(source, javaType);
        }
        catch (IOException e) {
            throw new ForestConvertException(this, (Throwable)e);
        }
    }

    @Override
    public String encodeToString(Object obj) {
        try {
            return this.getMapper().writeValueAsString(obj);
        }
        catch (Throwable e) {
            throw new ForestConvertException(this, e);
        }
    }

    @Override
    public Map<String, Object> convertObjectToMap(Object obj, ForestRequest request, ConvertOptions options) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>(objMap.size());
            for (Object key : objMap.keySet()) {
                Object val;
                String name = String.valueOf(key);
                if (options != null && options.shouldExclude(name) || Lazy.isEvaluatingLazyValue(val = objMap.get(key), request) || options != null && options.shouldIgnore(val = options.getValue(val, request)) || val == null) continue;
                newMap.put(name, val);
            }
            return newMap;
        }
        if (obj instanceof CharSequence) {
            return this.convertToJavaObject(obj.toString(), LinkedHashMap.class);
        }
        ObjectMapper objectMapper = this.getMapper();
        MapType javaType = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, Object.class);
        Map map = (Map)objectMapper.convertValue(obj, (JavaType)javaType);
        Method[] methods = ReflectUtils.getMethods(obj.getClass());
        for (int i = 0; i < methods.length; ++i) {
            String propName;
            String name;
            Method method = methods[i];
            if (!Lazy.class.isAssignableFrom(method.getReturnType()) || method.getParameters().length != 0 || !NameUtils.isGetter(name = method.getName()) || !map.containsKey(propName = NameUtils.propNameFromGetter(name))) continue;
            try {
                Object val = method.invoke(obj, new Object[0]);
                if (!(val instanceof Lazy) || Lazy.isEvaluatingLazyValue(val, request) || options != null && options.shouldIgnore(val = options.getValue(val, request))) continue;
                map.put(propName, val);
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ForestRuntimeException(e);
            }
        }
        return map;
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.JSON;
    }

    private class LazySerializer
    extends JsonSerializer<Lazy> {
        private LazySerializer() {
        }

        public void serialize(Lazy lazy, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNull();
        }
    }
}

