/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.dtflys.forest.converter.ConvertOptions;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.http.ForestBody;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.Lazy;
import com.dtflys.forest.http.body.BinaryRequestBody;
import com.dtflys.forest.http.body.ByteArrayRequestBody;
import com.dtflys.forest.http.body.NameValueRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.http.body.StringRequestBody;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public interface ForestJsonConverter
extends ForestConverter<String>,
ForestEncoder {
    public Map<String, Object> convertObjectToMap(Object var1, ForestRequest var2, ConvertOptions var3);

    default public Map<String, Object> convertObjectToMap(Object obj, ForestRequest request) {
        return this.convertObjectToMap(obj, request, ConvertOptions.defaultOptions());
    }

    default public Map<String, Object> convertObjectToMap(Object obj) {
        return this.convertObjectToMap(obj, null, ConvertOptions.defaultOptions());
    }

    public void setDateFormat(String var1);

    public String getDateFormat();

    @Override
    default public byte[] encodeRequestBody(ForestBody body, Charset charset, ConvertOptions options) {
        Charset cs = charset != null ? charset : StandardCharsets.UTF_8;
        LinkedList<ForestRequestBody> bodyList = new LinkedList<ForestRequestBody>(body);
        ForestRequest request = body.getRequest();
        if (!bodyList.isEmpty()) {
            LinkedList<ForestRequestBody> toJsonObj = bodyList;
            LinkedHashMap<String, Object> jsonMap = null;
            LinkedList<Object> jsonArray = null;
            if (bodyList.size() == 1 && (bodyList.get(0) instanceof StringRequestBody || bodyList.get(0) instanceof BinaryRequestBody)) {
                return ((ForestRequestBody)bodyList.get(0)).getByteArray();
            }
            for (ForestRequestBody bodyItem : bodyList) {
                Object obj;
                if (bodyItem instanceof NameValueRequestBody) {
                    Object value;
                    if (jsonMap == null) {
                        jsonMap = new LinkedHashMap<String, Object>(bodyList.size());
                    }
                    NameValueRequestBody nameValueItem = (NameValueRequestBody)bodyItem;
                    String name = nameValueItem.getName();
                    if (options != null && options.shouldExclude(name) || Lazy.isEvaluatingLazyValue(value = nameValueItem.getOriginalValue(), request) || options != null && options.shouldIgnore(value = options.getValue(value, request))) continue;
                    jsonMap.put(name, value);
                    continue;
                }
                if (bodyItem instanceof StringRequestBody) {
                    String content = bodyItem.toString();
                    Map<String, Object> subMap = this.convertObjectToMap(content, request);
                    if (subMap != null) {
                        if (jsonMap == null) {
                            jsonMap = new LinkedHashMap(bodyList.size());
                        }
                        jsonMap.putAll(subMap);
                        continue;
                    }
                    jsonArray = jsonArray != null ? jsonArray : new LinkedList<Object>();
                    jsonArray.add(content);
                    continue;
                }
                if (!(bodyItem instanceof ObjectRequestBody) || (obj = ((ObjectRequestBody)bodyItem).getObject()) == null) continue;
                Class<?> cls = obj.getClass();
                if (obj instanceof Collection) {
                    jsonArray = jsonArray != null ? jsonArray : new LinkedList<Object>();
                    jsonArray.addAll((Collection)obj);
                    continue;
                }
                if (!(obj instanceof byte[]) && cls.isArray()) {
                    jsonArray = jsonArray != null ? jsonArray : new LinkedList<Object>();
                    int len = Array.getLength(obj);
                    for (int i = 0; i < len; ++i) {
                        Object item = Array.get(obj, i);
                        jsonArray.add(item);
                    }
                    continue;
                }
                Map<String, Object> subMap = this.convertObjectToMap(obj, request, options);
                if (subMap == null) continue;
                if (jsonMap == null) {
                    jsonMap = new LinkedHashMap(bodyList.size());
                }
                jsonMap.putAll(subMap);
            }
            if (jsonMap != null) {
                toJsonObj = jsonMap;
            } else if (jsonArray != null) {
                toJsonObj = jsonArray;
            }
            String text = null;
            if (toJsonObj instanceof CharSequence || toJsonObj instanceof StringRequestBody) {
                text = ((Object)toJsonObj).toString();
                return text.getBytes(cs);
            }
            if (toJsonObj instanceof ObjectRequestBody) {
                text = this.encodeToString(((ObjectRequestBody)((Object)toJsonObj)).getObject());
                return text.getBytes(cs);
            }
            if (toJsonObj instanceof NameValueRequestBody) {
                HashMap<String, Object> subMap = new HashMap<String, Object>(1);
                subMap.put(((NameValueRequestBody)((Object)toJsonObj)).getName(), ((NameValueRequestBody)((Object)toJsonObj)).getValue());
                text = this.encodeToString(subMap);
                return text.getBytes(cs);
            }
            if (toJsonObj instanceof ByteArrayRequestBody) {
                byte[] bytes = ((ByteArrayRequestBody)((Object)toJsonObj)).getByteArray();
                return bytes;
            }
            text = this.encodeToString(toJsonObj);
            return text.getBytes(cs);
        }
        return new byte[0];
    }
}

