/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.json;

import com.dtflys.forest.converter.json.ForestFastjson2Converter;
import com.dtflys.forest.converter.json.ForestFastjsonConverter;
import com.dtflys.forest.converter.json.ForestGsonConverter;
import com.dtflys.forest.converter.json.ForestJacksonConverter;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import java.io.Serializable;

public class JSONConverterSelector
implements Serializable {
    private static JSONConverterSelector instance;
    private ForestJsonConverter cachedJsonConverter;

    public static JSONConverterSelector getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new JSONConverterSelector();
        return instance;
    }

    public Class checkFastJSONClass() throws Throwable {
        return Class.forName("com.alibaba.fastjson.JSON");
    }

    public Class checkFastJSON2Class() throws Throwable {
        return Class.forName("com.alibaba.fastjson2.JSON");
    }

    public Class checkJacsonClass() throws Throwable {
        return Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
    }

    public Class checkGsonClass() throws Throwable {
        return Class.forName("com.google.gson.JsonParser");
    }

    public ForestJsonConverter select() {
        if (this.cachedJsonConverter != null) {
            return this.cachedJsonConverter;
        }
        try {
            this.checkFastJSON2Class();
            this.cachedJsonConverter = new ForestFastjson2Converter();
            return this.cachedJsonConverter;
        }
        catch (Throwable throwable) {
            try {
                this.checkFastJSONClass();
                this.cachedJsonConverter = new ForestFastjsonConverter();
                return this.cachedJsonConverter;
            }
            catch (Throwable throwable2) {
                try {
                    this.checkJacsonClass();
                    this.cachedJsonConverter = new ForestJacksonConverter();
                    return this.cachedJsonConverter;
                }
                catch (Throwable throwable3) {
                    try {
                        this.checkGsonClass();
                        this.cachedJsonConverter = new ForestGsonConverter();
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    return this.cachedJsonConverter;
                }
            }
        }
    }
}

