/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.protobuf;

import com.dtflys.forest.converter.protobuf.ForestProtobufConverter;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.utils.ForestDataType;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public class ForestGoogleProtobufConverter
implements ForestProtobufConverter {
    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType) {
        Class c = (Class)targetType;
        try {
            Method method = c.getDeclaredMethod("parser", new Class[0]);
            Parser parser = (Parser)method.invoke(null, new Object[0]);
            return (T)parser.parseFrom(source);
        }
        catch (InvalidProtocolBufferException | ReflectiveOperationException e) {
            throw new ForestConvertException(this, e);
        }
    }

    @Override
    public byte[] convertToByte(Object source) {
        Class<?> aClass = source.getClass();
        if (!Message.class.isAssignableFrom(aClass)) {
            return new byte[0];
        }
        Message message = (Message)source;
        return message.toByteArray();
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        return this.convertToJavaObject(source, targetType);
    }

    @Override
    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        return this.convertToJavaObject(source, targetType);
    }

    @Override
    public ForestDataType getDataType() {
        return ForestDataType.PROTOBUF;
    }
}

