/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.protobuf;

import com.dtflys.forest.converter.protobuf.ForestProtobufConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.utils.ReflectUtils;
import java.io.Serializable;
import java.lang.reflect.Type;

public class ForestProtobufConverterManager
implements Serializable {
    private static ForestProtobufConverterManager instance;
    private static final String PROTOBUF_CONVERTER_CLASS = "com.dtflys.forest.converter.protobuf.ForestGoogleProtobufConverter";
    private static final String PROTOBUF_MESSAGE_CLASS = "com.google.protobuf.Message";
    private ForestProtobufConverter forestProtobufConverter;
    private volatile Class messageClass;
    private volatile Boolean supportProtobuf = null;

    public static ForestProtobufConverterManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ForestProtobufConverterManager();
        return instance;
    }

    public boolean checkSupportProtobuf() {
        if (this.supportProtobuf != null) {
            return this.supportProtobuf;
        }
        try {
            Class.forName("com.google.protobuf.Parser");
        }
        catch (Throwable ignored) {
            this.supportProtobuf = false;
            return false;
        }
        this.supportProtobuf = true;
        return true;
    }

    private Class<?> getMessageClass() {
        if (!this.checkSupportProtobuf()) {
            return null;
        }
        if (this.messageClass == null) {
            try {
                this.messageClass = Class.forName(PROTOBUF_MESSAGE_CLASS);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.messageClass;
    }

    public boolean isProtobufMessageClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (!this.checkSupportProtobuf()) {
            return false;
        }
        Class<?> messageClazz = this.getMessageClass();
        return messageClazz.isAssignableFrom(clazz);
    }

    public boolean isProtobufMessageType(Type type) {
        if (type == null) {
            return false;
        }
        Class<?> clazz = ReflectUtils.toClass(type);
        return this.isProtobufMessageClass(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForestProtobufConverter getForestProtobufConverter() {
        if (this.forestProtobufConverter == null) {
            ForestProtobufConverterManager forestProtobufConverterManager = this;
            synchronized (forestProtobufConverterManager) {
                if (this.forestProtobufConverter == null && this.checkSupportProtobuf()) {
                    try {
                        Class<?> clazz = Class.forName(PROTOBUF_CONVERTER_CLASS);
                        this.forestProtobufConverter = (ForestProtobufConverter)clazz.newInstance();
                    }
                    catch (Throwable th) {
                        throw new ForestRuntimeException("forestProtobufConverter create exception", th);
                    }
                }
            }
        }
        return this.forestProtobufConverter;
    }
}

