/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.exceptions;

import com.dtflys.forest.exceptions.ForestPoolException;
import java.text.MessageFormat;
import java.util.concurrent.ThreadPoolExecutor;

public class ForestAsyncAbortException
extends ForestPoolException {
    private final Runnable task;
    private final ThreadPoolExecutor pool;

    public ForestAsyncAbortException(Runnable task, ThreadPoolExecutor pool) {
        super(null, ForestAsyncAbortException.message(task, pool));
        this.task = task;
        this.pool = pool;
    }

    public Runnable getTask() {
        return this.task;
    }

    public ThreadPoolExecutor getPool() {
        return this.pool;
    }

    private static String message(Runnable task, ThreadPoolExecutor pool) {
        String threadName = Thread.currentThread().getName();
        String msg = "[Forest] Asynchronous thread pool is full! [Thread name: {0}, Max pool size: {1}, Core pool size: {2}, Active pool size: {3}, Task count: {4}]";
        return MessageFormat.format("[Forest] Asynchronous thread pool is full! [Thread name: {0}, Max pool size: {1}, Core pool size: {2}, Active pool size: {3}, Task count: {4}]", threadName, pool.getMaximumPoolSize(), pool.getCorePoolSize(), pool.getActiveCount(), pool.getActiveCount());
    }
}

