/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.exceptions;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.utils.StringUtils;

public class ForestNetworkException
extends ForestRuntimeException {
    private Integer statusCode;
    private ForestResponse response;

    public ForestNetworkException(String message, Integer statusCode, ForestResponse response) {
        super(ForestNetworkException.errorMessage(message, statusCode, response));
        this.statusCode = statusCode;
        this.response = response;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public ForestResponse getResponse() {
        return this.response;
    }

    private static String errorMessage(String message, Integer statusCode, ForestResponse response) {
        String content;
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP ").append(statusCode).append(" Error");
        if (StringUtils.isNotEmpty(message)) {
            builder.append(": ").append(message);
        }
        if (response != null && (content = response.getContent()) != null) {
            if (StringUtils.isNotEmpty(message)) {
                builder.append("; ");
            }
            builder.append("Content=").append(content);
        }
        return builder.toString();
    }
}

