/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.exceptions;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;

public class ForestRetryException
extends ForestRuntimeException {
    private final int maxRetryCount;
    private final int currentRetryCount;
    private final ForestRequest request;
    private final boolean needRetry;

    public ForestRetryException(ForestRequest request, int maxRetryCount, int currentRetryCount, boolean needRetry) {
        super("[Forest] retry count: " + currentRetryCount);
        this.needRetry = needRetry;
        this.request = request;
        this.maxRetryCount = maxRetryCount;
        this.currentRetryCount = currentRetryCount;
    }

    public ForestRetryException(ForestRequest request, int maxRetryCount, int currentRetryCount) {
        this(request, maxRetryCount, currentRetryCount, true);
    }

    public ForestRetryException(Throwable cause, ForestRequest request, int maxRetryCount, int currentRetryCount) {
        super("[Forest] retry count: " + currentRetryCount + ", cause: " + cause.getMessage(), cause);
        this.needRetry = true;
        this.request = request;
        this.maxRetryCount = maxRetryCount;
        this.currentRetryCount = currentRetryCount;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public int getCurrentRetryCount() {
        return this.currentRetryCount;
    }

    public ForestRequest getRequest() {
        return this.request;
    }

    public boolean isNeedRetry() {
        return this.needRetry;
    }

    public boolean isMaxRetryCountReached() {
        return this.currentRetryCount == this.maxRetryCount;
    }

    @Override
    public synchronized Throwable getCause() {
        Throwable cause = super.getCause();
        if (cause != null) {
            return cause;
        }
        return new ForestRetryException(this.request, this.maxRetryCount, this.currentRetryCount, false);
    }
}

