/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.handler;

import com.dtflys.forest.backend.ContentType;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.exceptions.ForestHandlerException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.reflection.MethodLifeCycleHandler;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.ReflectUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.Future;

public class ResultHandler {
    protected boolean isReceivedResponseData(ForestResponse response) {
        if (response == null) {
            return false;
        }
        return response.isReceivedResponseData();
    }

    public Object getResult(ForestRequest request, ForestResponse response, Type resultType) {
        Class<?> clazz = ReflectUtils.toClass(resultType);
        return this.getResult(request, response, resultType, clazz);
    }

    public Object getResult(ForestRequest request, ForestResponse response, Class resultClass) {
        Type type = ReflectUtils.toType(resultClass);
        return this.getResult(request, response, type, resultClass);
    }

    public Object getResult(ForestRequest request, ForestResponse response, Type resultType, Class resultClass) {
        if (request.isDownloadFile()) {
            return null;
        }
        if (this.isReceivedResponseData(response)) {
            try {
                ParameterizedType parameterizedType;
                Class rowClass;
                if (Void.TYPE.isAssignableFrom(resultClass)) {
                    return null;
                }
                if (ForestResponse.class.isAssignableFrom(resultClass) || ForestRequest.class.isAssignableFrom(resultClass)) {
                    ParameterizedType parameterizedType2;
                    Class rowClass2;
                    if (resultType instanceof ParameterizedType && (ForestResponse.class.isAssignableFrom(rowClass2 = (Class)(parameterizedType2 = (ParameterizedType)resultType).getRawType()) || ForestRequest.class.isAssignableFrom(resultClass))) {
                        Type realType = parameterizedType2.getActualTypeArguments()[0];
                        Class<Object> realClass = ReflectUtils.toClass(parameterizedType2.getActualTypeArguments()[0]);
                        if (realClass == null) {
                            realClass = String.class;
                        }
                        Object realResult = this.getResult(request, response, realType, realClass);
                        response.setResult(realResult);
                    }
                    return response;
                }
                if (Future.class.isAssignableFrom(resultClass) && resultType instanceof ParameterizedType && Future.class.isAssignableFrom(rowClass = (Class)(parameterizedType = (ParameterizedType)resultType).getRawType())) {
                    Type realType = parameterizedType.getActualTypeArguments()[0];
                    Class<?> realClass = ReflectUtils.toClass(parameterizedType.getActualTypeArguments()[0]);
                    if (realClass == null) {
                        return ((MethodLifeCycleHandler)request.getLifeCycleHandler()).getResultData();
                    }
                    return this.getResult(request, response, realType, realClass);
                }
                if (resultClass.isArray() && byte[].class.isAssignableFrom(resultClass)) {
                    return response.getByteArray();
                }
                Object attFile = request.getAttachment("__file");
                if (attFile != null && attFile instanceof File) {
                    ForestConverter converter = request.getConfiguration().getConverter(ForestDataType.JSON);
                    return converter.convertToJavaObject(attFile, resultClass);
                }
                String responseText = null;
                if (CharSequence.class.isAssignableFrom(resultClass)) {
                    try {
                        responseText = response.readAsString();
                    }
                    catch (Throwable th) {
                        request.getLifeCycleHandler().handleError(request, response, th);
                    }
                } else {
                    try {
                        responseText = response.getContent();
                    }
                    catch (Throwable th) {
                        request.getLifeCycleHandler().handleError(request, response, th);
                    }
                }
                response.setContent(responseText);
                if (InputStream.class.isAssignableFrom(resultClass)) {
                    return response.getInputStream();
                }
                ContentType contentType = response.getContentType();
                ForestConverter decoder = request.getDecoder();
                if (decoder != null) {
                    if (contentType != null && contentType.canReadAsString()) {
                        return decoder.convertToJavaObject(responseText, resultType);
                    }
                    String charset = response.getCharset();
                    return decoder.convertToJavaObject(response.getByteArray(), resultType, Charset.forName(Optional.ofNullable(charset).orElse("UTF-8")));
                }
                if (CharSequence.class.isAssignableFrom(resultClass)) {
                    return responseText;
                }
                ForestDataType dataType = request.getDataType();
                ForestConverter converter = request.getConfiguration().getConverter(dataType);
                if (contentType != null && contentType.canReadAsString()) {
                    return converter.convertToJavaObject(responseText, resultType);
                }
                Charset charset = null;
                String resCharset = response.getCharset();
                if (resCharset != null) {
                    charset = Charset.forName(resCharset);
                }
                return converter.convertToJavaObject(response.getByteArray(), resultType, charset);
            }
            catch (Exception e) {
                throw new ForestHandlerException(e, request, response);
            }
        }
        if (ForestResponse.class.isAssignableFrom(resultClass)) {
            return response;
        }
        return null;
    }
}

