/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class ForestAddress {
    private final String scheme;
    private final String host;
    private final int port;
    private final String userInfo;
    private final String basePath;

    public ForestAddress(String scheme, String host, int port, String basePath) {
        String schemeStr = scheme;
        String hostStr = host;
        int portNum = port;
        String userinfoStr = null;
        String basePathStr = basePath;
        if (basePathStr != null && !(basePathStr = basePath.trim()).startsWith("/")) {
            if (URLUtils.isURL(basePathStr)) {
                try {
                    String originHost = host;
                    URL url = new URL(basePathStr);
                    if (StringUtils.isEmpty(scheme)) {
                        schemeStr = url.getProtocol();
                    }
                    userinfoStr = url.getUserInfo();
                    if (StringUtils.isEmpty(host)) {
                        hostStr = url.getHost();
                    }
                    if (URLUtils.isNonePort(port) && StringUtils.isEmpty(originHost)) {
                        portNum = url.getPort();
                    }
                    basePathStr = url.getPath();
                }
                catch (MalformedURLException e) {
                    throw new ForestRuntimeException(e);
                }
            } else {
                basePathStr = "/" + basePathStr;
            }
        }
        this.scheme = schemeStr;
        this.host = hostStr;
        this.port = portNum;
        this.userInfo = userinfoStr;
        this.basePath = basePathStr;
    }

    public ForestAddress(String scheme, String host, Integer port, String basePath) {
        this(scheme, host, port == null ? -1 : port, basePath);
    }

    public ForestAddress(String scheme, String host, int port) {
        this(scheme, host, port, (String)null);
    }

    public ForestAddress(String scheme, String host, Integer port) {
        this(scheme, host, port == null ? -1 : port);
    }

    public ForestAddress(String host, int port) {
        this((String)null, host, port);
    }

    public ForestAddress(String host, Integer port) {
        this((String)null, host, port);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

