/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.converter.ConvertOptions;
import com.dtflys.forest.converter.ForestEncoder;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestUnsupportException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.BinaryRequestBody;
import com.dtflys.forest.http.body.ByteArrayRequestBody;
import com.dtflys.forest.http.body.FileRequestBody;
import com.dtflys.forest.http.body.InputStreamRequestBody;
import com.dtflys.forest.http.body.MultipartRequestBody;
import com.dtflys.forest.http.body.NameValueRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.http.body.StringRequestBody;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.Validations;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ForestBody
implements List<ForestRequestBody> {
    private final ForestRequest request;
    private ForestDataType defaultBodyType = ForestDataType.BINARY;
    private ForestDataType bodyType;
    private ForestEncoder encoder;
    private List<ForestRequestBody> bodyItems = new LinkedList<ForestRequestBody>();

    public ForestRequest getRequest() {
        return this.request;
    }

    public ForestBody(ForestRequest request) {
        this.request = request;
    }

    public ForestEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(ForestEncoder encoder) {
        this.encoder = encoder;
    }

    public NameValueRequestBody getNameValueBody(String name) {
        Validations.assertParamNotEmpty(name, "name");
        for (ForestRequestBody body : this.bodyItems) {
            if (!(body instanceof NameValueRequestBody) || !name.equals(((NameValueRequestBody)body).getName())) continue;
            return (NameValueRequestBody)body;
        }
        return null;
    }

    public List<NameValueRequestBody> getNameValueBodies(String name) {
        LinkedList<NameValueRequestBody> bodies = new LinkedList<NameValueRequestBody>();
        Validations.assertParamNotEmpty(name, "name");
        for (ForestRequestBody body : this.bodyItems) {
            if (!(body instanceof NameValueRequestBody) || !name.equals(((NameValueRequestBody)body).getName())) continue;
            bodies.add((NameValueRequestBody)body);
        }
        return bodies;
    }

    public Map<String, Object> nameValuesMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (ForestRequestBody body : this.bodyItems) {
            NameValueRequestBody nameValueRequestBody;
            String name;
            if (!(body instanceof NameValueRequestBody) || map.containsKey(name = (nameValueRequestBody = (NameValueRequestBody)body).getName())) continue;
            map.put(name, nameValueRequestBody.getValue());
        }
        return map;
    }

    public Map<String, Object> nameValuesMapWithObject() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ForestJsonConverter jsonConverter = this.request.getConfiguration().getJsonConverter();
        for (ForestRequestBody body : this.bodyItems) {
            if (body instanceof NameValueRequestBody) {
                NameValueRequestBody nameValueRequestBody = (NameValueRequestBody)body;
                String name = nameValueRequestBody.getName();
                if (map.containsKey(name)) continue;
                map.put(name, nameValueRequestBody.getValue());
                continue;
            }
            if (!(body instanceof ObjectRequestBody)) continue;
            ObjectRequestBody objectRequestBody = (ObjectRequestBody)body;
            Map<String, Object> keyValueMap = jsonConverter.convertObjectToMap(objectRequestBody.getObject(), this.request);
            for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (map.containsKey(name)) continue;
                map.put(name, value);
            }
        }
        return map;
    }

    public <T extends ForestRequestBody> List<T> getItems(Class<T> bodyItemClass) {
        LinkedList<ForestRequestBody> items = new LinkedList<ForestRequestBody>();
        for (ForestRequestBody item : this.bodyItems) {
            Class<?> itemClass = item.getClass();
            if (!bodyItemClass.isAssignableFrom(itemClass)) continue;
            items.add(item);
        }
        return items;
    }

    public List<StringRequestBody> getStringItems() {
        return this.getItems(StringRequestBody.class);
    }

    public List<NameValueRequestBody> getNameValueItems() {
        return this.getItems(NameValueRequestBody.class);
    }

    public List<ObjectRequestBody> getObjectItems() {
        return this.getItems(ObjectRequestBody.class);
    }

    public List<ByteArrayRequestBody> getByteArrayItems() {
        return this.getItems(ByteArrayRequestBody.class);
    }

    public List<InputStreamRequestBody> getInputStreamItems() {
        return this.getItems(InputStreamRequestBody.class);
    }

    public List<BinaryRequestBody> getBinaryItems() {
        return this.getItems(BinaryRequestBody.class);
    }

    public List<FileRequestBody> getFileItems() {
        return this.getItems(FileRequestBody.class);
    }

    public List<MultipartRequestBody> getMultipartItems() {
        return this.getItems(MultipartRequestBody.class);
    }

    public ForestDataType getDefaultBodyType() {
        return this.defaultBodyType;
    }

    public ForestDataType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(ForestDataType bodyType) {
        this.bodyType = bodyType;
    }

    @Override
    public int size() {
        return this.bodyItems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bodyItems.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        for (ForestRequestBody body : this.bodyItems) {
            if (!(body instanceof NameValueRequestBody) || !key.equals(((NameValueRequestBody)body).getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (ForestRequestBody body : this.bodyItems) {
            byte[] bytes;
            if (body instanceof NameValueRequestBody && value.equals(((NameValueRequestBody)body).getValue())) {
                return true;
            }
            if (body instanceof ObjectRequestBody && value.equals(((ObjectRequestBody)body).getObject())) {
                return true;
            }
            if (body instanceof StringRequestBody && value.equals(((StringRequestBody)body).getContent())) {
                return true;
            }
            if (!byte[].class.isAssignableFrom(value.getClass()) || !Objects.equals(bytes = body.getByteArray(), bytes)) continue;
            return true;
        }
        return false;
    }

    public Object setNameValue(String key, Object value) {
        if (key == null) {
            return null;
        }
        NameValueRequestBody body = this.getNameValueBody(key);
        Object oldValue = null;
        if (key != null) {
            oldValue = body.getValue();
            body.setValue(value);
        }
        return oldValue;
    }

    private ForestEncoder selectEncoder(ForestDataType type) {
        if (ForestDataType.MULTIPART == type) {
            throw new ForestUnsupportException("Forest encoder do not support the body type \"MULTIPART\"");
        }
        ForestDataType dataType = type == null ? this.request.mineContentType().bodyType() : type;
        ForestEncoder forestEncoder = Optional.ofNullable((ForestEncoder)((Object)this.request.getConfiguration().getConverter(dataType))).orElseGet(() -> (ForestEncoder)((Object)this.request.getConfiguration().getConverter(ForestDataType.TEXT)));
        return forestEncoder;
    }

    private ForestEncoder selectEncoder() {
        return this.selectEncoder(this.bodyType);
    }

    public byte[] encode(ForestEncoder encoder, Charset charset, ConvertOptions options) {
        ConvertOptions opts = options != null ? options : ConvertOptions.defaultOptions();
        return encoder.encodeRequestBody(this, charset, opts);
    }

    public byte[] encode(ForestEncoder encoder, Charset charset) {
        return this.encode(encoder, charset, ConvertOptions.defaultOptions());
    }

    public byte[] encode(ForestDataType type, Charset charset, ConvertOptions options) {
        return this.encode(this.selectEncoder(type), charset, options);
    }

    public byte[] encode(ForestDataType type, Charset charset) {
        return this.encode(type, charset, ConvertOptions.defaultOptions());
    }

    public byte[] encode(ForestDataType type, ConvertOptions options) {
        return this.encode(type, StandardCharsets.UTF_8, options);
    }

    public byte[] encode(ForestDataType type) {
        return this.encode(type, StandardCharsets.UTF_8);
    }

    public byte[] encode(Charset charset, ConvertOptions options) {
        if (this.encoder != null) {
            return this.encode(this.encoder, charset, options);
        }
        return this.encode(this.selectEncoder(), charset, options);
    }

    public byte[] encode(Charset charset) {
        return this.encode(charset, ConvertOptions.defaultOptions());
    }

    public byte[] encode(ConvertOptions options) {
        return this.encode(StandardCharsets.UTF_8, options);
    }

    public byte[] encode() {
        return this.encode(ConvertOptions.defaultOptions());
    }

    public String encodeToString(ForestEncoder encoder, Charset charset, ConvertOptions options) {
        byte[] bytes = this.encode(encoder, charset, options);
        return new String(bytes);
    }

    public String encodeToString(ForestEncoder encoder, Charset charset) {
        return this.encodeToString(encoder, charset, ConvertOptions.defaultOptions());
    }

    public String encodeToString(ForestDataType type, Charset charset, ConvertOptions options) {
        return this.encodeToString(this.selectEncoder(type), charset, options);
    }

    public String encodeToString(ForestDataType type, Charset charset) {
        return this.encodeToString(type, charset, ConvertOptions.defaultOptions());
    }

    public String encodeToString(ForestDataType type, ConvertOptions options) {
        return this.encodeToString(type, StandardCharsets.UTF_8, options);
    }

    public String encodeToString(ForestDataType type) {
        return this.encodeToString(type, ConvertOptions.defaultOptions());
    }

    public String encodeToString(Charset charset, ConvertOptions options) {
        if (this.encoder != null) {
            return this.encodeToString(this.encoder, charset, options);
        }
        return this.encodeToString(this.selectEncoder(), charset, options);
    }

    public String encodeToString(Charset charset) {
        return this.encodeToString(charset, ConvertOptions.defaultOptions());
    }

    public String encodeToString(ConvertOptions options) {
        String strCharset = this.request.getCharset();
        if (StringUtils.isEmpty(strCharset)) {
            strCharset = this.request.getConfiguration().getCharset();
        }
        if (StringUtils.isEmpty(strCharset)) {
            strCharset = "UTF-8";
        }
        return this.encodeToString(Charset.forName(strCharset), options);
    }

    public String encodeToString() {
        return this.encodeToString(ConvertOptions.defaultOptions());
    }

    @Override
    public boolean contains(Object o) {
        return this.bodyItems.contains(o);
    }

    @Override
    public Iterator<ForestRequestBody> iterator() {
        return this.bodyItems.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.bodyItems.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.bodyItems.toArray(a);
    }

    @Override
    public boolean add(ForestRequestBody forestRequestBody) {
        if (this.bodyType == null) {
            this.defaultBodyType = forestRequestBody.getDefaultBodyType();
        }
        forestRequestBody.setBody(this);
        return this.bodyItems.add(forestRequestBody);
    }

    public void replaceNameValue(NameValueRequestBody nameValueRequestBody) {
        NameValueRequestBody body = this.getNameValueBody(nameValueRequestBody.getName());
        if (body != null) {
            body.setValue(nameValueRequestBody.getValue());
            body.setValue(nameValueRequestBody.getDefaultValue());
            body.setContentType(nameValueRequestBody.getContentType());
        }
    }

    @Override
    public boolean remove(Object o) {
        return this.bodyItems.remove(o);
    }

    public <T extends ForestRequestBody> boolean remove(Class<T> bodyItemClass) {
        LinkedList<Boolean> rets = new LinkedList<Boolean>();
        for (ForestRequestBody item : this.bodyItems) {
            Class<?> itemClass = item.getClass();
            if (!bodyItemClass.isAssignableFrom(itemClass)) continue;
            rets.add(this.bodyItems.remove(item));
        }
        if (rets.isEmpty()) {
            return false;
        }
        return rets.stream().allMatch(ret -> ret);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.bodyItems.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends ForestRequestBody> c) {
        for (ForestRequestBody forestRequestBody : c) {
            forestRequestBody.setBody(this);
        }
        return this.bodyItems.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ForestRequestBody> c) {
        for (ForestRequestBody forestRequestBody : c) {
            forestRequestBody.setBody(this);
        }
        return this.bodyItems.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.bodyItems.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.bodyItems.retainAll(c);
    }

    @Override
    public void clear() {
        for (ForestRequestBody item : this.bodyItems) {
            item.setBody(null);
        }
        this.bodyItems.clear();
    }

    @Override
    public ForestRequestBody get(int index) {
        return this.bodyItems.get(index);
    }

    @Override
    public ForestRequestBody set(int index, ForestRequestBody element) {
        return this.bodyItems.set(index, element);
    }

    @Override
    public void add(int index, ForestRequestBody element) {
        element.setBody(this);
        this.bodyItems.add(index, element);
    }

    @Override
    public ForestRequestBody remove(int index) {
        ForestRequestBody item = this.bodyItems.remove(index);
        if (item != null) {
            item.setBody(null);
        }
        return item;
    }

    @Override
    public int indexOf(Object o) {
        return this.bodyItems.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.bodyItems.lastIndexOf(o);
    }

    @Override
    public ListIterator<ForestRequestBody> listIterator() {
        return this.bodyItems.listIterator();
    }

    @Override
    public ListIterator<ForestRequestBody> listIterator(int index) {
        return this.bodyItems.listIterator();
    }

    @Override
    public List<ForestRequestBody> subList(int fromIndex, int toIndex) {
        return this.bodyItems.subList(fromIndex, toIndex);
    }

    public ForestBody clone() {
        return this.clone(this.request);
    }

    public ForestBody clone(ForestRequest request) {
        ForestBody newBody = new ForestBody(request);
        for (ForestRequestBody item : this.bodyItems) {
            newBody.add(item.clone());
        }
        return newBody;
    }
}

